
require 'sketchup.rb'
require 'Win32API'
require 'Phlatboyz/Phlatscript.rb'


class GPlot

  def initialize
    @PlotGCode = Win32API.new("C:/Program Files/Google/Google SketchUp 7/Plugins/GPlot.dll", "PlotGCode", ['P'], 'V')
  end

  def plot
    filename = PhlatScript.cncFileDir + '/' + PhlatScript.cncFileName
    if (filename) && (File.exist?(filename)) then
      @PlotGCode.call(filename)
    else
      UI.messagebox("Could not locate a gcode file to plot. Try using the generate gcode button.")
    end
  end

end

#-----------------------------------------------------------------------------
if( not file_loaded?("GPlot.rb") )
    UI.menu("Plugins").add_item("Plot GCode") { GPlot.new.plot }
end
#-----------------------------------------------------------------------------
file_loaded("GPlot.rb")

