require 'sketchup.rb'
def gcd3(one,other)
	min = one.abs
	max = other.abs
	min, max = max % min, min while (min > 0)
	max
end
def retrieve_selection(extra)
	selection = Sketchup.active_model.selection
	side = []
	sides = []
	alledges = []
	selection.each {|looptemp| alledges.push(looptemp)}
	allelse = alledges.reject{|looptemp| looptemp.typename == "Edge"}#extract construction points from this
	alledges.reject!{|looptemp| looptemp.typename != "Edge"}
	while (alledges.length > 0)
		side.push(alledges.pop)
		side.each do
			|looptemp|
			looptemp.vertices.each do
				|loopt|
				(loopt.edges & alledges).each do
					|lpt|
					side.push lpt
					alledges.delete lpt
				end
			end
		end
		sides.push(Array.new(side))
		side.clear
	end
	return sides.push(allelse) if extra
	return sides
end
def organize(startpoint, edges)
	if (startpoint != nil)
		verts = [startpoint]
	else
		verts = [edges.collect{|looptemp|looptemp.vertices}.flatten.uniq.reject{|looptemp|looptemp.edges.length > 1}[0]]
		verts = edges[0] if (edges[0] == nil)
	end
	verts.push(((edges.delete((verts.last.edges & edges)[0])).vertices.reject{|looptemp|looptemp == verts.last})[0]) while ((verts.last.edges & edges).length != 0)
	return(verts.collect{|looptemp|looptemp.position})
end
def clean_selection(entities)
	Sketchup.active_model.start_operation "Clean Selection"
	selection = Sketchup.active_model.selection
	if (entities)
		selection.clear
		selection.add entities
	end
	junk = []
	selection.each {|looptemp|junk.push(looptemp) if (looptemp.typename == "Edge")&&((looptemp.faces.length == 0)||((looptemp.faces.length == 2)&&(looptemp.faces[0].material == looptemp.faces[1].material)&&(looptemp.faces[0].normal.parallel?(looptemp.faces[1].normal))))}
	junk.each{|looptemp|looptemp.erase!}
	Sketchup.active_model.commit_operation
	return entities
end
def multiply_points(points, amount)
	addpoints = []
	(points.length - 1).times do
		|index|
		addpoints.push []
		(amount - 1).times do
			|number|
			addpoints.last.push(Geom::Point3d.linear_combination((amount - number - 1)/amount.to_f, points[index], (number + 1)/amount.to_f, points[index + 1]))
		end
	end
	points = points.zip addpoints
	points.flatten!
	points.pop
	return points
end
def evenize_points(points, length)
	temp = Array.new(points)
	temp.shift
	points.pop
	points = points.zip(temp)
	if(length == nil)
		length = points.sort{|a, b|a[0].distance(a[1]) <=> b[0].distance(b[1])}[0]
		length = length[0].distance length[1]
	end
	points.collect! do
		|looptemp|
		if (looptemp[0].distance(looptemp[1]) < length*2)
			looptemp
		else
			multiply_points(looptemp, (looptemp[0].distance(looptemp[1])/length).truncate)
		end
	end
	points.flatten!
	points.uniq!
	return points
end
def prep
	Sketchup.active_model.start_operation "Edge Slicing"
	sides = retrieve_selection(false)
	sides.collect!{|looptemp|organize(looptemp[0].vertices[0], looptemp)}
	if (sides.length == 1)
		sides.collect!{|looptemp|multiply_points(looptemp, UI.inputbox(["Slice Amount"])[0].to_i)}
	elsif(Sketchup.active_model.options[4]["Skin.Prep Method"] == "By Length")
		sides.collect!{|looptemp|evenize_points(looptemp, nil)}
	elsif(Sketchup.active_model.options[4]["Skin.Prep Method"] == "By Number")
		mult = sides.sort{|a,b|a.length <=> b.length}.last.length-1
		sides.collect!{|looptemp|multiply_points(looptemp, mult/(looptemp.length-1).truncate)}
	end
	temp = nil
	sides.each do
		|looptemp|
		temp = Array.new(looptemp)
		temp.shift
		looptemp.pop
		looptemp = looptemp.zip temp
		looptemp.each{|loopt|Sketchup.active_model.selection.add(Sketchup.active_model.entities.add_edges(loopt[0], loopt[1]))}
	end
	Sketchup.active_model.commit_operation
	skin if (sides.length != 1)
end
def attach(leftpoints, rightpoints)
	Sketchup.active_model.start_operation "Skin Part"
	thesefaces = []
	leftpos = 0
	0.upto(rightpoints.length - 2) do
		|looptemp|
		while (leftpoints[leftpos + 1] != nil && ((looptemp.to_f/(rightpoints.length - 1)*(leftpoints.length.truncate - 1) > leftpos && (Sketchup.active_model.options[4]["Skin.Skin Method"] == "By Order"))||(rightpoints[looptemp + 1].distance(leftpoints[leftpos]) > rightpoints[looptemp].distance(leftpoints[leftpos + 1]) && (Sketchup.active_model.options[4]["Skin.Skin Method"] == "By Distance"))))
			thesefaces.push([rightpoints[looptemp], leftpoints[leftpos], leftpoints[leftpos + 1]])
			leftpos += 1
		end
		thesefaces.push([rightpoints[looptemp], leftpoints[leftpos], rightpoints[looptemp + 1]])
	end
	leftpos.upto(leftpoints.length - 2){|looptemp|thesefaces.push([rightpoints.last, leftpoints[looptemp], leftpoints[looptemp + 1]])}
	thesefaces.collect!{|looptemp|Sketchup.active_model.entities.add_face(looptemp)}
	return thesefaces
end
def skin
	all = []
	sides = retrieve_selection(false)#change arg to true sometime
	sides.collect! do
		|looptemp|
		if (looptemp.collect{|loopt|loopt.vertices}.flatten.uniq.reject{|loopt|loopt.edges.length != 1}.length == 2)
			organize(nil, looptemp)
		else##Redo
			organize(looptemp.collect{|loopt|loopt.vertices}.flatten.uniq.sort{|a, b|(b.position.x + b.position.y + b.position.z)<=>(a.position.x + a.position.y + a.position.z)}[0], looptemp)
		end
	end
	sides.unshift(sides.delete(sides.sort{|a, b|Geom::BoundingBox.new.add(a).center.distance([0, 0, 0]) <=> Geom::BoundingBox.new.add(b).center.distance([0, 0, 0])}.last))
	sidesets = []
	sides.sort!{|a,b|Geom::BoundingBox.new.add(a).center.distance(sides[0][0]) <=> Geom::BoundingBox.new.add(b).center.distance(sides[0][0])}
	0.upto(sides.length - 2){|looptemp|sidesets.push([sides[looptemp], sides[looptemp + 1]])}
	#curves memorize
	sidesets.each do
		|looptemp|
		looptemp[1].reverse! if (looptemp[1].first.distance(looptemp[0].first) > looptemp[1].last.distance(looptemp[0].first))
		all.push attach(looptemp[0], looptemp[1])
		if (UI.messagebox("Is this connection done right?", MB_YESNO, "Quality Check") == 7)# && UI.messagebox("Shall I try to fix my error?", MB_YESNO, "Answer, Please") == 6)
			all.pop
			Sketchup.undo
			looptemp[0].reverse!
			all.push attach(looptemp[0], looptemp[1])
		end
	end
	all.flatten!
	all.each{|looptemp|Sketchup.active_model.selection.add(looptemp.edges)}
	Sketchup.active_model.selection.add all
	clean_selection(nil) if (Sketchup.active_model.options[4]["Skin.Clean?"] == "Yes")
	#curves smooth
end
def set_settings
	options = Sketchup.active_model.options[4]
	prompts = ["Skin Method", "Prep Method", "Clean?", "Smooth?"]
	values = [options["Skin.Skin Method"], options["Skin.Prep Method"], options["Skin.Clean?"], options["Skin.Smooth?"]]
	#dropdwns = ["By Distance|By Order", "None|By Length|By Number", "Yes|No", "Yes|No"]
	dropdwns = ["By Distance|By Order", "None|By Length|By Number", "Yes|No", "Unavailible"]
	results = inputbox(prompts, values, dropdwns, "Skin Options")
	options["Skin.Skin Method"] = results[0]
	options["Skin.Prep Method"] = results[1]
	options["Skin.Clean?"] = results[2]
	options["Skin.Smooth?"] = results[3]
end
class OptionsEnsurer <  Sketchup::AppObserver
	def checkOptions(model)
		if (Sketchup.active_model.options[4]["Skin.Skin Method"] == nil)
			Sketchup.active_model.options[4]["Skin.Skin Method"] = "By Distance"
			Sketchup.active_model.options[4]["Skin.Prep Method"] = "None"
			Sketchup.active_model.options[4]["Skin.Clean?"] = "Yes"
			Sketchup.active_model.options[4]["Skin.Smooth?"] = "Unavailible"
		end
	end
	def onNewModel (model)
		checkOptions(model)
	end
	def onOpenModel (model)
		checkOptions(model)
	end
end
sets = UI::Command.new("Set Settings") {set_settings}
sets.small_icon = "skin/SetS.png"
sets.large_icon = "skin/SetL.png"
sets.tooltip = "Sets the skinning settings"
skin = UI::Command.new("Skin") {prep}
skin.small_icon = "skin/SkinS.png"
skin.large_icon = "skin/SkinL.png"
skin.tooltip = "Connects the selected groups of entities."
clean = UI::Command.new("Clean") {clean_selection(nil)}
clean.small_icon = "skin/CleanS.png"
clean.large_icon = "skin/CleanL.png"
clean.tooltip = "Removes all coplanar or empty selected edges."
if not (file_loaded? "skin.rb")
	add_separator_to_menu("Tools")
	skinm = UI.menu("Tools").add_submenu("Skin")
	skinm.add_item("Clean Selection") {clean_selection(nil)}
	skinm.add_item("Skin") {skin}
	skinm.add_item("Set Settings") {set_settings}
	Skin = UI::Toolbar.new("Skin")
	Skin.add_item(sets)
	Skin.add_item(skin)
	Skin.add_item(clean)
end
file_loaded("skin.rb")