﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows.Forms;
using MacGen;
using System.IO;
namespace CSharpBasicViewerApp
{
public partial class frmViewer : Form 
{ 
    private string mCncFile; 
    private clsProcessor mProcessor = clsProcessor.Instance(); 
    private clsSettings mSetup = clsSettings.Instance(); 
    private MG_CS_BasicViewer mViewer; 
    
    public frmViewer(){
        InitializeComponent();
        mViewer = this.MG_Viewer1; 
        mProcessor.OnAddBlock += new clsProcessor.OnAddBlockEventHandler(mProcessor_OnAddBlock);
        
        MG_CS_BasicViewer.OnSelection += new MG_CS_BasicViewer.OnSelectionEventHandler(mViewer_OnSelection);
        MG_CS_BasicViewer.MouseLocation += new MG_CS_BasicViewer.MouseLocationEventHandler(mViewer_MouseLocation);
        MG_CS_BasicViewer.OnStatus += new MG_CS_BasicViewer.OnStatusEventHandler(mViewer_OnStatus);
        
        mSetup.MachineActivated+=new clsSettings.MachineActivatedEventHandler(mSetup_MachineActivated);
        mSetup.MachineAdded +=new clsSettings.MachineAddedEventHandler(mSetup_MachineAdded);
        mSetup.MachineDeleted +=new clsSettings.MachineDeletedEventHandler(mSetup_MachineDeleted);
        mSetup.MachineLoaded +=new clsSettings.MachineLoadedEventHandler(mSetup_MachineLoaded);
        mSetup.MachineMatched += new clsSettings.MachineMatchedEventHandler(mSetup_MachineMatched);

        mSetup.LoadAllMachines(System.IO.Directory.GetCurrentDirectory() + "\\Data");
        mProcessor.Init(mSetup.Machine);
    }

    private void frmViewer_Load(object sender, System.EventArgs e) 
    { 
        int ret = this.tscboMachines.FindString(Properties.Settings.Default.LastMachine); 

        if (ret >= 0) { 
            this.tscboMachines.SelectedIndex = ret; 
        } 
        
        if (Properties.Settings.Default.Virgin == true) { 
            this.StartPosition = FormStartPosition.CenterScreen; 
        } 
        else { 
            this.Location = Properties.Settings.Default.ViewFormLocation; 
            this.Size = Properties.Settings.Default.ViewFormSize; 
        } 

        OpenFile(System.IO.Directory.GetCurrentDirectory() + "\\Samples\\Mill.cnc"); 
        SetDefaultViews(); 
        Properties.Settings.Default.Virgin = false; 
    } 
    
    private void frmViewer_FormClosing(object sender, System.Windows.Forms.FormClosingEventArgs e) 
    { 
        try { 
            if (this.WindowState == FormWindowState.Normal) { 
                Properties.Settings.Default.ViewFormLocation = this.Location; 
                Properties.Settings.Default.ViewFormSize = this.Size; 
            } 
            Properties.Settings.Default.LastMachine = this.tscboMachines.SelectedItem.ToString(); 
        } 
        catch { 
        } 
    } 
    
     private void OpenFile(string fileName) 
    { 
        long[] ticks = new long[2]; 
        mCncFile = fileName; 
        mSetup.MatchMachineToFile(mCncFile); 
        
        ProcessFile(mCncFile); 
        mViewer.BreakPoint = MG_CS_BasicViewer.MotionBlocks.Count - 1; 
        
        mViewer.Pitch = mSetup.Machine.ViewAngles[0]; 
        mViewer.Roll = mSetup.Machine.ViewAngles[1]; 
        mViewer.Yaw = mSetup.Machine.ViewAngles[2]; 
        mViewer.Init(); 
        
        ticks[0] = DateTime.Now.Ticks; 
        MG_Viewer1.FindExtents(); 
        ticks[1] = DateTime.Now.Ticks; 
        MG_Viewer1.DynamicViewManipulation = (ticks[1] - ticks[0]) < 2000000; 
        MG_Viewer2.FindExtents(); 
        MG_Viewer3.FindExtents(); 
        MG_Viewer4.FindExtents(); 
        mViewer.Redraw(true); 
    } 
    
    
    private void ProcessFile(string fileName) 
    { 
        if (fileName == null) { 
            return; 
        } 
        if (!System.IO.File.Exists(fileName)) { 
            lblStatus.Text = "File does not exist!"; 
            return; 
        } 
        lblStatus.Text = "Processing..."; 
        MG_CS_BasicViewer.MotionBlocks.Clear(); 
        mProcessor.Init(mSetup.Machine); 
        mProcessor.ProcessFile(fileName, MG_CS_BasicViewer.MotionBlocks); 
        
        BreakPointSlider.Maximum = MG_CS_BasicViewer.MotionBlocks.Count - 1; 
        if (mViewer.BreakPoint > MG_CS_BasicViewer.MotionBlocks.Count - 1) { 
            mViewer.BreakPoint = MG_CS_BasicViewer.MotionBlocks.Count - 1; 
        } 
        mViewer.GatherTools(); 
        lblStatus.Text = "Done"; 
        Progress.Value = 0; 
        
    } 
    
    private void mnuViewOrient_Click(object sender, System.EventArgs e) 
    { 
        switch (((System.Windows.Forms.ToolStripMenuItem)sender).Tag.ToString()) { 
            case "Top": 
                mViewer.Pitch = 0; 
                mViewer.Roll = 0; 
                mViewer.Yaw = 0; 
                break; 
            case "Front": 
                mViewer.Pitch = 270; 
                mViewer.Roll = 0; 
                mViewer.Yaw = 360; 
                break; 
            case "Right": 
                mViewer.Pitch = 270; 
                mViewer.Roll = 0; 
                mViewer.Yaw = 270; 
                break; 
            case "ISO": 
                mViewer.Pitch = 315; 
                mViewer.Roll = 0; 
                mViewer.Yaw = 315; 
                break; 
        } 
        mViewer.FindExtents(); 
        mViewer.Redraw(true); 
    } 
     
    private void mViewer_MouseLocation(float x, float y) 
    { 
        Coordinates.Text = "X=" + x.ToString("0.000") + " Y=" + y.ToString("0.000"); 
    } 
     
    private void mProcessor_OnAddBlock(int idx, int ct) 
    { 
        try { 
            this.Progress.Maximum = ct; 
            this.Progress.Value = idx; 
            if (ct > 10000) { 
                //Refresh every 1000 blocks 
                if (1000 % idx == 0) { 
                    mViewer.FindExtents(); 
                    mViewer.Redraw(true); 
                } 
            } 
        } 
        catch (Exception ex) { 
        } 
        
    } 
     
    private void ViewportActivated(object sender, System.EventArgs e) 
    { 
        mViewer = (MG_CS_BasicViewer)sender; 
    } 
    
    private void SetDefaultViews() 
    { 
        //Case "Top" 
        MG_Viewer1.Pitch = 0f; 
        MG_Viewer1.Roll = 0f; 
        MG_Viewer1.Yaw = 0f; 
        MG_Viewer1.FindExtents(); 
        //Case "Front" 
        MG_Viewer3.Pitch = 270f; 
        MG_Viewer3.Roll = 0f; 
        MG_Viewer3.Yaw = 360f; 
        MG_Viewer3.FindExtents(); 
        
        //Case "Right" 
        MG_Viewer4.Pitch = 270f; 
        MG_Viewer4.Roll = 0f; 
        MG_Viewer4.Yaw = 270f; 
        MG_Viewer4.FindExtents(); 
        
        //Case "ISO" 
        MG_Viewer2.Pitch = 315f; 
        MG_Viewer2.Roll = 0f; 
        MG_Viewer2.Yaw = 315f; 
        MG_Viewer2.FindExtents(); 
        mViewer.Redraw(true); 
    } 
    
    private void mViewer_OnSelection(System.Collections.Generic.List<clsMotionRecord> hits) 
    { 
        lblStatus.Text = hits[0].Codestring; 
        string[] tipString = new string[hits.Count]; 
        for (int r = 0; r <= hits.Count - 1; r++) { 
            tipString[r] = hits[r].Codestring; 
        } 
        this.CodeTip.SetToolTip(mViewer, string.Join(Environment.NewLine, tipString)); 
    } 
    
    private void mViewer_OnStatus(string msg, int index, int max) 
    { 
        lblStatus.Text = msg; 
        Progress.Maximum = max; 
        Progress.Value = index; 
        StatusStrip1.Refresh(); 
    } 
      
    private void mSetup_MachineActivated(clsMachine m) 
    { 
        { 
            MG_Viewer1.RotaryDirection = (RotaryDirection)m.RotaryDir; 
            MG_Viewer1.RotaryPlane = (Axis)m.RotaryAxis; 
            MG_Viewer1.RotaryType = (RotaryMotionType)m.RotaryType; 
            MG_Viewer1.ViewManipMode = MG_CS_BasicViewer.ManipMode.SELECTION;
            
            MG_Viewer1.FindExtents();
            MG_Viewer2.FindExtents();
            MG_Viewer3.FindExtents();
            MG_Viewer4.FindExtents();
            mViewer.Redraw(true);

        } 
    } 
    
    private void mSetup_MachineAdded(clsMachine m) 
    { 
        tscboMachines.Items.Add(m.Name); 
    } 
    
    private void mSetup_MachineDeleted(string name) 
    { 
        tscboMachines.Items.RemoveAt(tscboMachines.FindStringExact(name)); 
    } 
    
    private void mSetup_MachineLoaded(clsMachine m) 
    { 
        tscboMachines.Items.Add(m.Name); 
    } 
    
    private void mSetup_MachineMatched(clsMachine m) 
    { 
        tscboMachines.SelectedIndex = tscboMachines.FindStringExact(m.Name); 
    } 
    
  
    private void mSetup_MachinesCleared() 
    { 
        tscboMachines.Items.Clear(); 
    } 
    

    private void BreakPointSlider_ValueChanged(object sender, EventArgs e)
    {
        mViewer.BreakPoint = BreakPointSlider.Value;
        mViewer.Redraw(true);
    }

    private void ViewButtonClicked(object sender, EventArgs e)
    {
        string tag = sender.GetType().GetProperty("Tag").GetValue(sender, null).ToString();
        switch (tag)
        {
            case "Fit":
                if (Control.ModifierKeys==Keys.Shift)
                {
                    MG_Viewer1.FindExtents();
                    MG_Viewer2.FindExtents();
                    MG_Viewer3.FindExtents();
                    MG_Viewer4.FindExtents();
                }
                else
                {
                    mViewer.FindExtents();
                }

                break;
            case "Pan":
                mViewer.ViewManipMode = MG_CS_BasicViewer.ManipMode.PAN;
                tsbPan.Checked = true;
                tsbRotate.Checked = false;
                tsbZoom.Checked = false;
                tsbFence.Checked = false;
                tsbSelect.Checked = false;
                break;
            case "Fence":
                mViewer.ViewManipMode = MG_CS_BasicViewer.ManipMode.FENCE;
                tsbFence.Checked = true;
                tsbRotate.Checked = false;
                tsbZoom.Checked = false;
                tsbPan.Checked = false;
                tsbSelect.Checked = false;
                break;
            case "Zoom":
                mViewer.ViewManipMode = MG_CS_BasicViewer.ManipMode.ZOOM;
                tsbZoom.Checked = true;
                tsbRotate.Checked = false;
                tsbFence.Checked = false;
                tsbPan.Checked = false;
                tsbSelect.Checked = false;
                break;
            case "Rotate":
                mViewer.ViewManipMode = MG_CS_BasicViewer.ManipMode.ROTATE;
                tsbRotate.Checked = true;
                tsbZoom.Checked = false;
                tsbFence.Checked = false;
                tsbPan.Checked = false;
                tsbSelect.Checked = false;
                break;
            case "Select":
                mViewer.ViewManipMode = MG_CS_BasicViewer.ManipMode.SELECTION;
                tsbRotate.Checked = false;
                tsbZoom.Checked = false;
                tsbFence.Checked = false;
                tsbPan.Checked = false;
                tsbSelect.Checked = true;
                break;
        } 

    }

    private void ScreensClicked(object sender, EventArgs e)
    {

        {
            switch (((ToolStripMenuItem)sender).Tag.ToString())
            {
                case "1":
                    this.tblScreens.RowStyles[1].Height = 0;
                    this.tblScreens.ColumnStyles[1].Width = 0;
                    MG_Viewer2.Visible = false;
                    MG_Viewer3.Visible = false;
                    MG_Viewer4.Visible = false;
                    break;
                case "2":
                    this.tblScreens.RowStyles[1].Height = 0;
                    this.tblScreens.ColumnStyles[1].Width = 50;
                    MG_Viewer2.Visible = true;
                    MG_Viewer3.Visible = false;
                    MG_Viewer4.Visible = false;
                    break;
                case "4":
                    this.tblScreens.RowStyles[1].Height = 50;
                    this.tblScreens.ColumnStyles[1].Width = 50;
                    MG_Viewer2.Visible = true;
                    MG_Viewer3.Visible = true;
                    MG_Viewer4.Visible = true;
                    break;
            }
            SetDefaultViews();
        } 
    }

    private void tscboMachines_SelectedIndexChanged(object sender, EventArgs e)
    {
        mSetup.MachineName = tscboMachines.SelectedItem.ToString();
    }

    private void frmViewer_ResizeEnd(object sender, EventArgs e)
    {
        MG_Viewer1.FindExtents();
        MG_Viewer2.FindExtents();
        MG_Viewer3.FindExtents();
        MG_Viewer4.FindExtents();
        mViewer.Redraw(true);
    }

    private void tsbOpen_Click(object sender, EventArgs e)
    {
           OpenFileDialog1.ShowDialog();
           this.Refresh();
            if(OpenFileDialog1.FileName.Length > 0){
                OpenFile(OpenFileDialog1.FileName);
            }
    }

    private void DisplayCheckChanged(object sender, EventArgs e)
    {
        if(mViewer == null) return;

        mViewer.DrawRapidLines = mnuRapidLines.Checked;
        mViewer.DrawRapidPoints = mnuRapidPoints.Checked;
        mViewer.DrawAxisLines = mnuAxisLines.Checked;
        mViewer.DrawAxisIndicator = mnuAxisindicator.Checked;
        mViewer.Redraw(true);
    }

    private void tsbToolsFilter_Click(object sender, EventArgs e)
    {

           TreeNode nd = default(TreeNode);
            using (frmToolLayers frm = new frmToolLayers())
            {
                frm.tvTools.Nodes.Clear();
                foreach (clsToolLayer tl in MG_CS_BasicViewer.ToolLayers.Values)
                {
                    nd = frm.tvTools.Nodes.Add("Tool " + tl.Number.ToString());
                    nd.ForeColor = tl.Color;
                    nd.Checked = !tl.Hidden;
                    nd.Tag = tl;
                }
                frm.tvTools.BackColor = this.MG_Viewer1.BackColor;
                frm.StartPosition = FormStartPosition.Manual;
                frm.Location = Control.MousePosition;
                frm.ShowDialog();
            }
            mViewer.Redraw(true);
        }

    private void tsbWebCheck_Click(object sender, EventArgs e)
    {
        System.Diagnostics.Process.Start(Properties.Resources.datBasicViewerUrl + "1.0");
    } 
   
   } 
}