Module ModGlobal

    Public AppPath As String 'Directory that program is installed in
    Private mSetup As clsSettings = clsSettings.Instance
    Private mProcessor As clsProcessor = clsProcessor.Instance
    Public Sub Main()
        Try
            Application.EnableVisualStyles()
            AppPath = My.Computer.FileSystem.CurrentDirectory
            If Not My.Computer.FileSystem.DirectoryExists(AppPath & "\Data") Then
                My.Computer.FileSystem.CreateDirectory(AppPath & "\Data")
            End If
            Using f As New frmViewer 'Load this here so the events hook up
                mSetup.LoadAllMachines(AppPath & "\Data")
                mProcessor.Init(mSetup.Machine)
                f.ShowDialog()
            End Using
            My.Settings.Save()
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation)
        End Try
    End Sub
End Module
