Option Strict On
Option Explicit On
Option Compare Text
Imports System.Collections.Generic
Imports System.Text.RegularExpressions
''' <summary>
''' Processes the cnc file and loads the graphics records.
''' </summary>
''' <remarks>
''' Copyright  MacGen Programming 2006
''' Jason Titcomb
''' www.CncEdit.com
''' </remarks>
Class clsProcessor
    Private mColors16() As Integer = {-16777216, -8388608, -16744448, -8355840, -16777088, -8388480, -16744320, -4144960, -8355712, -65536, -16711936, -256, -16776961, -12525360, -65281, -1}

    Private mRegSubs As Regex
    Private mRegWords As Regex

    Private mCodefile As String 'the input file
    Private mPlane As Integer
    Private mDrillClear As Single
    Private mCurrentColor As Integer
    Private mSubFiles As New Specialized.StringCollection

    Private mInitialZBeforeDrill As Single
    Private mEndmain As String 'M30
    Private mSubcall As String 'M98
    Private mSubRepeats As String 'L
    Private mSubFileNumber As Integer
    Private mSang, mRad, mEang As Single
    Private mYcentr, mXcentr, mZcentr As Single
    Private mJ, mI, mK As Single
    Private mYpos, mXpos, mZpos As Single
    Private mPrevY, mPrevX, mPrevZ As Single
    Private mPrevABC, mABC As Single
    Private mRotDir As Integer
    Private mRotating As Boolean
    Private mRpoint As Single
    Private mDrillReturnMode As Motion 'G98,G99
    Private mArcRad As Single
    Private mFeed As Single
    Private mSpeed As Single
    Private mTool As Single
    Private mPrevTool As Single
    Private mMode As Motion
    Private mAbsolute As Boolean
    Private mCodeText As String
    Private mTotalLines As Integer
    Private mTotalBites As Integer
    Private mMotion As New clsMotion
    Private mCurAddress As Address
    Private mNewProfile As Boolean
    Private mGrfxRec As clsMotionRecord
    Private mGfxRecs As System.Collections.Generic.List(Of clsMotionRecord)
    Public mCurMachine As clsMachine
    Private Const ONE_RADIAN As Single = Math.PI * 2
    Private Enum letters
        A
        B
        C
        D
        E
        F
        G
        H
        I
        J
        K
        L
        M
        N
        O
        P
        Q
        R
        S
        T
        U
        V
        W
        X
        Y
        Z
        ANY
    End Enum
    Private mBlockAddresses(26) As Boolean
    Public Event OnAddBlock(ByVal value As Integer, ByVal max As Integer)
    Public Event OnToolChanged(ByVal tool As Single)

#Region "Singleton"
    Private Shared mInstance As clsProcessor
    'PRIVATE constructor can only be called from this class
    Private Sub New()
    End Sub
    ''' <summary>
    ''' Static method for creating the single instance of the Constructor
    ''' </summary>
    Public Shared Function Instance() As clsProcessor
        ' initialize if not already done
        If mInstance Is Nothing Then
            mInstance = New clsProcessor
        End If
        ' return the initialized instance of the Singleton Class
        Return mInstance
    End Function 'Instance
#End Region

    Private Class clsProg
        Public Main As Boolean
        Public Label As String
        Public Value As Integer
        Public Index As Integer
        Public Contents As String
        Public TimesCalled As Integer = 0
    End Class

    Private mNcProgs As New System.Collections.Generic.List(Of clsProg)

    Private Sub Arc_Center()
        Dim side_opposite As Single
        Dim meanX As Single
        Dim meanY As Single
        Dim centerVector As Single
        Dim quarterArc As Single

        Select Case mPlane
            Case Motion.XY_PLN
                'This is for an arc or helix that uses an R insdead of I,J,K,

                If mBlockAddresses(letters.R) And (mMode > Motion.LINE) Then 'Radius move with R
                    quarterArc = Math.PI / 2
                    '|------- Calculate arc center position -------|

                    If mArcRad < 0 Then 'A "-R" is used to specify big arc
                        quarterArc = -quarterArc 'Total angle > 180 deg
                    End If 'Total angle is always <180 if "+R"

                    If mPrevX = mXpos And mPrevY = mYpos Then 'this is a full arc
                        quarterArc = 0
                    End If

                    mRad = System.Math.Abs(mArcRad)
                    'calculate side opposite 'hypotenuse
                    side_opposite = CSng(System.Math.Abs((mRad ^ 2) - ((MG_BasicViewer.VectorLength(mPrevX, mPrevY, 0, mXpos, mYpos, 0) / 2) ^ 2)))
                    side_opposite = CSng(System.Math.Sqrt(side_opposite))
                    'find mid point of start and end of arc start and end points
                    meanX = (mPrevX + mXpos) / 2
                    meanY = (mPrevY + mYpos) / 2

                    If mMode = Motion.CCARC Then
                        centerVector = MG_BasicViewer.AngleFromPoint(mXpos - mPrevX, mYpos - mPrevY, False) - quarterArc
                        If centerVector < 0 Then
                            centerVector = ONE_RADIAN + centerVector
                        End If

                    End If

                    If mMode = Motion.CWARC Then
                        centerVector = MG_BasicViewer.AngleFromPoint(mXpos - mPrevX, mYpos - mPrevY, False) + quarterArc
                        If centerVector > ONE_RADIAN Then
                            centerVector = centerVector - ONE_RADIAN
                        End If
                    End If


                    mXcentr = CSng(meanX - (side_opposite * System.Math.Cos(centerVector)))
                    mYcentr = CSng(meanY - (side_opposite * System.Math.Sin(centerVector)))

                    'Calculate start and end angle
                    mSang = MG_BasicViewer.AngleFromPoint(mPrevX - mXcentr, mPrevY - mYcentr, False)
                    mEang = MG_BasicViewer.AngleFromPoint(mXpos - mXcentr, mYpos - mYcentr, False)
                Else

                    If mCurMachine.AbsArcCenter Then
                        mI = mI - mPrevX
                        mJ = mJ - mPrevY
                    End If

                    mRad = CSng(System.Math.Sqrt(mI ^ 2 + mJ ^ 2)) 'calculate rad
                    mXcentr = mPrevX + mI 'Arc origins
                    mYcentr = mPrevY + mJ
                    mZcentr = mPrevZ + mK
                    mSang = MG_BasicViewer.AngleFromPoint(mPrevX - mXcentr, mPrevY - mYcentr, False)
                    mEang = MG_BasicViewer.AngleFromPoint(mXpos - mXcentr, mYpos - mYcentr, False)

                End If 'InStr(codeline, "R")

            Case Motion.XZ_PLN
                'This is for an arc or helix that uses an R insdead of I,J,K,

                If mBlockAddresses(letters.R) And mMode > Motion.LINE Then 'Radius move with R
                    quarterArc = Math.PI / 2
                    '|------- Calculate arc center position -------|

                    If mArcRad < 0 Then 'A "-R" is used to specify big arc
                        quarterArc = -quarterArc 'Total angle > 180 deg
                    End If 'Total angle is always <180 if "+R"

                    If mPrevX = mXpos And mPrevZ = mZpos Then 'this is a full arc
                        quarterArc = 0
                    End If

                    mRad = System.Math.Abs(mArcRad)
                    'calculate side opposite 'hypotenuse
                    side_opposite = CSng(System.Math.Abs((mRad ^ 2) - ((MG_BasicViewer.VectorLength(mPrevX, mPrevZ, 0, mXpos, mZpos, 0) / 2) ^ 2)))
                    side_opposite = CSng(System.Math.Sqrt(side_opposite))
                    'find mid point of start and end of arc start and end points
                    meanX = (mPrevX + mXpos) / 2
                    meanY = (mPrevZ + mZpos) / 2

                    If mMode = Motion.CCARC Then
                        centerVector = MG_BasicViewer.AngleFromPoint(mXpos - mPrevX, mZpos - mPrevZ, False) - quarterArc
                        If centerVector < 0 Then
                            centerVector = ONE_RADIAN + centerVector
                        End If

                    End If

                    If mMode = Motion.CWARC Then
                        centerVector = MG_BasicViewer.AngleFromPoint(mXpos - mPrevX, mZpos - mPrevZ, False) + quarterArc
                        If centerVector > ONE_RADIAN Then
                            centerVector = centerVector - ONE_RADIAN
                        End If
                    End If


                    mXcentr = CSng(meanX - (side_opposite * System.Math.Cos(centerVector)))
                    mZcentr = CSng(meanY - (side_opposite * System.Math.Sin(centerVector)))

                    'Calculate start and end angle
                    mSang = MG_BasicViewer.AngleFromPoint(mPrevX - mXcentr, mPrevZ - mZcentr, False)
                    mEang = MG_BasicViewer.AngleFromPoint(mXpos - mXcentr, mZpos - mZcentr, False)
                Else

                    If mCurMachine.AbsArcCenter Then
                        mI = mI - mPrevX
                        mK = mK - mPrevZ
                    End If

                    mRad = CSng(System.Math.Sqrt(mI ^ 2 + mK ^ 2)) 'calculate rad
                    mXcentr = mPrevX + mI
                    mYcentr = mPrevY + mJ 'Arc origins
                    mZcentr = mPrevZ + mK

                    mSang = MG_BasicViewer.AngleFromPoint(mPrevX - mXcentr, mPrevZ - mZcentr, False)
                    mEang = MG_BasicViewer.AngleFromPoint(mXpos - mXcentr, mZpos - mZcentr, False)

                End If 'InStr(codeline, "R")

            Case Motion.YZ_PLN
                'This is for an arc or helix that uses an R insdead of I,J,K,

                If mBlockAddresses(letters.R) And mMode > Motion.LINE Then 'Radius move with R
                    quarterArc = Math.PI / 2
                    '|------- Calculate arc center position -------|

                    If mArcRad < 0 Then 'A "-R" is used to specify big arc
                        quarterArc = -quarterArc 'Total angle > 180 deg
                    End If 'Total angle is always <180 if "+R"

                    If mPrevY = mYpos And mPrevZ = mZpos Then 'this is a full arc
                        quarterArc = 0
                    End If

                    mRad = System.Math.Abs(mArcRad)
                    'calculate side opposite 'hypotenuse
                    side_opposite = CSng(System.Math.Abs((mRad ^ 2) - ((MG_BasicViewer.VectorLength(mPrevY, mPrevZ, 0, mYpos, mZpos, 0) / 2) ^ 2)))
                    side_opposite = CSng(System.Math.Sqrt(side_opposite))
                    'find mid point of start and end of arc start and end points
                    meanX = (mPrevY + mYpos) / 2
                    meanY = (mPrevZ + mZpos) / 2

                    If mMode = Motion.CCARC Then
                        centerVector = MG_BasicViewer.AngleFromPoint(mYpos - mPrevY, mZpos - mPrevZ, False) - quarterArc
                        If centerVector < 0 Then
                            centerVector = ONE_RADIAN + centerVector
                        End If

                    End If

                    If mMode = Motion.CWARC Then
                        centerVector = MG_BasicViewer.AngleFromPoint(mYpos - mPrevY, mZpos - mPrevZ, False) + quarterArc
                        If centerVector > ONE_RADIAN Then
                            centerVector = centerVector - ONE_RADIAN
                        End If
                    End If


                    mYcentr = CSng(meanX - (side_opposite * System.Math.Cos(centerVector)))
                    mZcentr = CSng(meanY - (side_opposite * System.Math.Sin(centerVector)))

                    'Calculate start and end angle
                    mSang = MG_BasicViewer.AngleFromPoint(mPrevY - mYcentr, mPrevZ - mZcentr, False)
                    mEang = MG_BasicViewer.AngleFromPoint(mYpos - mYcentr, mZpos - mZcentr, False)
                Else

                    If mCurMachine.AbsArcCenter Then
                        mJ = mJ - mPrevY
                        mK = mK - mPrevZ
                    End If

                    mRad = CSng(System.Math.Sqrt(mJ ^ 2 + mK ^ 2)) 'calculate rad
                    mXcentr = mPrevX + mI
                    mYcentr = mPrevY + mJ 'Arc origins
                    mZcentr = mPrevZ + mK

                    mSang = MG_BasicViewer.AngleFromPoint(mPrevY - mYcentr, mPrevZ - mZcentr, False)
                    mEang = MG_BasicViewer.AngleFromPoint(mYpos - mYcentr, mZpos - mZcentr, False)

                End If 'InStr(codeline, "R")

        End Select

    End Sub

    Private Sub AddMotionRecord()
        mGrfxRec = New clsMotionRecord
        With mGrfxRec
            .BeginProfile = mNewProfile
            .WrkPlane = mPlane
            .Tool = mTool
            .DrawClr = Color16(mCurrentColor)
            .Yold = mPrevY + mCurMachine.ViewShift(1)
            .Ycentr = mYcentr + mCurMachine.ViewShift(1)
            .Ypos = mYpos + mCurMachine.ViewShift(1)

            .Codestring = mCodeText
            .MotionType = mMode
            .Rpoint = mRpoint + mCurMachine.ViewShift(2)
            .DrillClear = mDrillClear
            .Xold = mPrevX + mCurMachine.ViewShift(0)
            .Xpos = mXpos + mCurMachine.ViewShift(0)
            .Rad = mRad
            .Xcentr = mXcentr + mCurMachine.ViewShift(0)

            .Zold = mPrevZ + mCurMachine.ViewShift(2)
            .Zpos = mZpos + mCurMachine.ViewShift(2)
            .Zcentr = mZcentr + mCurMachine.ViewShift(2)

            .Rotate = mRotating
            .NewRotaryPos = mABC
            .OldRotaryPos = mPrevABC
            .RotaryDir = mRotDir ' * mcurmachine.nRotaryDir

            .Speed = mSpeed
            .Feed = mFeed
            .Sang = mSang
            .Eang = mEang
        End With
        mGfxRecs.Add(mGrfxRec)
    End Sub

    Private Function FormatAxis(ByRef sVal As String, ByVal precision As Integer) As Single
        If sVal.Contains(".") Then 'decimal place
            Return Single.Parse(sVal)
        Else
            Return CSng(Single.Parse(sVal) * (10 ^ -precision)) 'convert a number from a 4 place
        End If
    End Function

    Public Sub ProcessFile(ByVal ncFile As String, ByVal gfxRecs As List(Of clsMotionRecord))
        mGfxRecs = gfxRecs
        mCodefile = ncFile
        With mMotion
            .SubCall.Label = mCurMachine.Subcall.Chars(0)
            .SubCall.Value = CInt(mCurMachine.Subcall.Substring(1))

            .SubReturn.Label = mCurMachine.SubReturn.Chars(0)
            .SubReturn.Value = CInt(mCurMachine.SubReturn.Substring(1))

            .Abs.Label = mCurMachine.Absolute.Chars(0)
            .Abs.Value = CInt(mCurMachine.Absolute.Substring(1))
            .CCArc.Label = mCurMachine.CCArc.Chars(0)
            .CCArc.Value = CInt(mCurMachine.CCArc.Substring(1))
            .CWArc.Label = mCurMachine.CWArc.Chars(0)
            .CWArc.Value = CInt(mCurMachine.CWArc.Substring(1))

            .Inc.Label = mCurMachine.Incremental.Chars(0)
            .Inc.Value = CInt(mCurMachine.Incremental.Substring(1))

            .Linear.Label = mCurMachine.Linear.Chars(0)
            .Linear.Value = CInt(mCurMachine.Linear.Substring(1))

            .Rapid.Label = mCurMachine.Rapid.Chars(0)
            .Rapid.Value = CInt(mCurMachine.Rapid.Substring(1))

            .Rotary.Label = mCurMachine.Rotary.Chars(0)
            .Rotary.Value = 0

            .DrillRapid.Label = mCurMachine.DrillRapid.Chars(0)
            .DrillRapid.Value = 0

            .Plane(0).Label = mCurMachine.XYplane.Chars(0)
            .Plane(0).Value = CInt(mCurMachine.XYplane.Substring(1))
            .Plane(1).Label = mCurMachine.XZplane.Chars(0)
            .Plane(1).Value = CInt(mCurMachine.XZplane.Substring(1))
            .Plane(2).Label = mCurMachine.YZplane.Chars(0)
            .Plane(2).Value = CInt(mCurMachine.YZplane.Substring(1))

            .ReturnLevel(0).Label = mCurMachine.ReturnLevel(0).Chars(0)
            .ReturnLevel(0).Value = CInt(mCurMachine.ReturnLevel(0).Substring(1))
            .ReturnLevel(1).Label = mCurMachine.ReturnLevel(1).Chars(0)
            .ReturnLevel(1).Value = CInt(mCurMachine.ReturnLevel(1).Substring(1))

            For r As Integer = 0 To .Drills.Length - 1
                If mCurMachine.Drills(r).Length > 2 Then
                    .Drills(r).Label = mCurMachine.Drills(r).Chars(0)
                    .Drills(r).Value = CInt(mCurMachine.Drills(r).Substring(1))
                End If
            Next

        End With

        'Reset all positions.
        mGfxRecs.Clear()
        mCurrentColor = 0
        mPrevTool = -1
        mXpos = 0
        mYpos = 0
        mZpos = 0
        mPrevX = 0
        mPrevY = 0
        mPrevZ = 0
        mPrevABC = 0
        mABC = 0
        mRpoint = 0
        mSpeed = 0
        mFeed = 0
        mDrillClear = 0
        mInitialZBeforeDrill = 0
        mRotDir = 1
        mAbsolute = True
        mMode = Motion.RAPID
        mDrillReturnMode = Motion.I_PLN

        If mCurMachine.MachineType = MachineType.MILL Then
            mPlane = Motion.XY_PLN 'Mill
        Else
            mPlane = Motion.XZ_PLN 'Lathe
        End If

        mEndmain = mCurMachine.Endmain.Trim
        mSubcall = mCurMachine.Subcall.Trim
        mSubRepeats = mCurMachine.SubRepeats.Trim

        Dim sFileContents As String
        Using MyReader As New IO.StreamReader(ncFile)
            sFileContents = Me.FilterJunk(MyReader.ReadToEnd())
        End Using
        mNcProgs.Clear()
        Dim lastIndex As Integer = -1
        Dim thisIndex As Integer = -1
        Dim p As clsProg
        For Each m As Match In Me.mRegSubs.Matches(sFileContents)
            If mCurMachine.ProgramId.Contains(m.Value(0)) Then
                thisIndex = m.Index
                'Each program
                If lastIndex > -1 Then
                    mNcProgs(mNcProgs.Count - 1).Contents = sFileContents.Substring(lastIndex, thisIndex - lastIndex).TrimEnd
                    If mNcProgs(mNcProgs.Count - 1).Contents.Contains(mCurMachine.Endmain) Then
                        mNcProgs(mNcProgs.Count - 1).Main = True
                    End If
                End If
                p = New clsProg
                p.Main = False
                p.Index = thisIndex
                p.Label = [Char].ToUpper(m.Value(0))
                p.Value = Integer.Parse(m.Groups(1).Value)
                mNcProgs.Add(p)
                lastIndex = m.Index
            End If
        Next

        mTotalLines = 1
        If mNcProgs.Count = 0 Then
            'Just add all the text we found in the file
            p = New clsProg
            p.Main = True
            p.Index = 0
            p.Label = "MAIN"
            p.Value = 0
            p.Contents = sFileContents
            mNcProgs.Add(p)
            mTotalBites = sFileContents.Length
            ProcessSubWords(p)
        Else
            mNcProgs(mNcProgs.Count - 1).Contents = sFileContents.Substring(lastIndex).TrimEnd
            If mNcProgs(mNcProgs.Count - 1).Contents.Contains(mCurMachine.Endmain) Then
                mNcProgs(mNcProgs.Count - 1).Main = True
            End If
            For Each p In mNcProgs
                mTotalBites = p.Contents.Length
                ProcessSubWords(p)
            Next
        End If


    End Sub

    Private Function FindSubByValue(ByVal val As Integer) As clsProg
        For Each p As clsProg In mNcProgs
            If p.Value = val Then Return p
        Next
        Return Nothing
    End Function

    Private Sub ProcessSubWords(ByVal p As clsProg)
        p.TimesCalled += 1
        Dim lastIndex As Integer = 0
        For Each ncWord As Match In Me.mRegWords.Matches(p.Contents)
            'Each word
            If ncWord.Value = vbLf Then 'Is this a newline
                mTotalLines += 1
                mCodeText = p.Contents.Substring(lastIndex, ncWord.Index - lastIndex - 1)
                CreateGcodeBlock()
                RaiseEvent OnAddBlock(ncWord.Index, mTotalBites)
                Array.Clear(mBlockAddresses, 0, 26)
                lastIndex = ncWord.Index + 1
            ElseIf MatchIsComment(ncWord) Then
                'Comment
                mTotalLines += ncWord.Value.Split(CChar(vbLf)).Length - 1
            ElseIf mCurMachine.BlockSkip.Contains(ncWord.Value.Chars(0)) Then
                'Blockskip.
                mTotalLines += 1
            Else
                'Word
                mCurAddress.Label = [Char].ToUpper(ncWord.Value(0))
                mCurAddress.StringValue = ncWord.Groups(1).Value
                mCurAddress.Value = CInt(ncWord.Groups(1).Value)
                If mCurAddress.Matches(mMotion.SubCall) Then
                    'M98 P. Use the next word value as the sub name
                    Dim retProg As clsProg = FindSubByValue(CInt(ncWord.NextMatch.Groups(1).Value))
                    If Not retProg Is Nothing Then
                        If retProg.TimesCalled > 100 Then Return 'Prevent infinate loop
                        ProcessSubWords(retProg) 'Call this subagain
                    End If
                Else
                    EvaluateWord()
                End If
            End If
        Next
    End Sub

    Private Sub CreateGcodeBlock()
        Static mPrevMode As MacGen.Motion = Motion.RAPID
        If Not mBlockAddresses(letters.ANY) Then Return

        If mBlockAddresses(letters.X) Then
            If mAbsolute = False Then
                mXpos = mXpos + mPrevX
            End If
            If mCurMachine.MachineType = MachineType.LATHEDIA Then
                mXpos = mXpos / 2
            End If
        End If
        If mBlockAddresses(letters.Y) Then
            If mAbsolute = False Then mYpos = mYpos + mPrevY
        End If
        If mBlockAddresses(letters.Z) Then
            If mAbsolute = False Then mZpos = mZpos + mPrevZ
        End If

        If mBlockAddresses(CInt([Enum].Parse(GetType(letters), mMotion.Rotary.Label))) Then
            mRotating = True
            If mCurMachine.RotaryType = RotaryMotionType.BMC Then '0>360 sign determines dir
                If mAbsolute = False Then
                    mABC = mABC + mPrevABC
                End If
            Else 'like CAD
                If mAbsolute = False Then
                    mRotDir = System.Math.Sign(mABC)
                    mABC = mABC + mPrevABC
                Else
                    'In a scale that runs from zero to 360
                    'we determine the direction based on the shortest distance.
                    If Math.Abs(mABC Mod ONE_RADIAN) > Math.PI And Math.Abs(mPrevABC Mod ONE_RADIAN) < Math.PI Then
                        mPrevABC += ONE_RADIAN
                    ElseIf Math.Abs(mABC Mod ONE_RADIAN) < Math.PI And Math.Abs(mPrevABC Mod ONE_RADIAN) > Math.PI Then
                        mPrevABC -= ONE_RADIAN
                    End If

                    If mABC < mPrevABC Then
                        mRotDir = -1
                    Else
                        mRotDir = 1
                    End If
                End If
            End If

        End If

        'Arc clockwise-------------------
        If mMode = Motion.CWARC Then
            Arc_Center() 'Calculate arc center
            If mSang <= mEang Then
                mSang = mSang + ONE_RADIAN
            End If

            're-calculate zpos if helix using k for pitch
            If mK > 0 And mPlane = Motion.XY_PLN Then
                If mSang = mEang Then
                    mZpos = mZpos + mK
                Else
                    mZpos = mZpos + (mK * (System.Math.Abs(mSang - mEang)) / ONE_RADIAN)
                End If
            End If

        End If

        'Arc anti-clockwise--------------
        If mMode = Motion.CCARC Then
            Arc_Center() 'Calculate arc center
            If mEang <= mSang Then
                mEang = mEang + ONE_RADIAN
            End If
            're-calculate zpos if helix using k for pitch
            If mK > 0 And mPlane = Motion.XY_PLN Then
                If mSang = mEang Then
                    mZpos = mZpos + mK
                Else
                    mZpos = mZpos + (mK * (System.Math.Abs(mSang - mEang)) / ONE_RADIAN)
                End If
            End If
        End If

        If mPrevTool <> mTool Then
            mNewProfile = True
            If mCurrentColor = 0 Then
                mCurrentColor = 9
            End If
            mCurrentColor = mCurrentColor + 1
            If mCurrentColor > 15 Then
                mCurrentColor = 1
            End If
            RaiseEvent OnToolChanged(mTool)
        End If

        If (mPrevMode = Motion.RAPID And mMode > Motion.RAPID) Or mPrevMode > Motion.RAPID And mMode = Motion.RAPID Then
            mNewProfile = True
        End If

        If mMode > Motion.RAPID Then
            mInitialZBeforeDrill = mZpos
        End If

        'Create the graphics record here
        AddMotionRecord()

        'Reset some values
        mPrevMode = Motion.RAPID
        mPrevTool = mTool
        mRotating = False
        mPrevABC = mABC
        'Lval = 0
        mI = 0
        mJ = 0
        mK = 0

        'Stores last position
        mPrevX = mXpos
        mPrevY = mYpos
        mPrevZ = mZpos
    End Sub

    Private Sub EvaluateWord()
        Dim r As Integer
        mBlockAddresses(CInt([Enum].Parse(GetType(letters), mCurAddress.Label))) = True
        Select Case mCurAddress.Label
            Case "X"c
                mBlockAddresses(letters.ANY) = True
                mXpos = FormatAxis(mCurAddress.StringValue, mCurMachine.Precision)
            Case "Y"c
                mBlockAddresses(letters.ANY) = True
                mYpos = FormatAxis(mCurAddress.StringValue, mCurMachine.Precision)
            Case "Z"c
                mBlockAddresses(letters.ANY) = True
                mZpos = FormatAxis(mCurAddress.StringValue, mCurMachine.Precision)
            Case "I"c
                mBlockAddresses(letters.ANY) = True
                mI = FormatAxis(mCurAddress.StringValue, mCurMachine.Precision)
                If mCurMachine.MachineType = MachineType.LATHEDIA Then
                    If mCurMachine.AbsArcCenter Then
                        mI = mI / 2
                    End If
                End If
            Case "J"c
                mBlockAddresses(letters.ANY) = True
                mJ = FormatAxis(mCurAddress.StringValue, mCurMachine.Precision)
            Case "K"c
                mBlockAddresses(letters.ANY) = True
                mK = FormatAxis(mCurAddress.StringValue, mCurMachine.Precision)
            Case "R"c
                mBlockAddresses(letters.ANY) = True
                mRpoint = FormatAxis(mCurAddress.StringValue, mCurMachine.Precision)
                mArcRad = mRpoint
            Case "S"c
                mBlockAddresses(letters.ANY) = True
                mSpeed = mCurAddress.Value
            Case "F"c
                mBlockAddresses(letters.ANY) = True
                mFeed = mCurAddress.Value
            Case "T"c
                mBlockAddresses(letters.ANY) = True
                mTool = mCurAddress.Value
            Case mMotion.Rotary.Label
                mBlockAddresses(letters.ANY) = True
                mABC = FormatAxis(mCurAddress.StringValue, mCurMachine.RotPrecision) * 0.0174532924F 'Convert to radians
                If mCurAddress.StringValue.StartsWith("-") Then 'check for -0
                    mRotDir = -1 'CCW
                End If

            Case Else

                If mCurAddress.Matches(mMotion.Abs) Then 'Absolute positioning
                    mBlockAddresses(letters.ANY) = True
                    mAbsolute = True
                ElseIf mCurAddress.Matches(mMotion.Inc) Then 'Incremental positioning
                    mBlockAddresses(letters.ANY) = True
                    mAbsolute = False
                ElseIf mCurAddress.Matches(mMotion.Rapid) Then
                    mBlockAddresses(letters.ANY) = True
                    mMode = Motion.RAPID
                ElseIf mCurAddress.Matches(mMotion.Linear) Then
                    mBlockAddresses(letters.ANY) = True
                    mMode = Motion.LINE
                ElseIf mCurAddress.Matches(mMotion.CWArc) Then  'Arc clockwise
                    mBlockAddresses(letters.ANY) = True
                    If mPlane = Motion.XZ_PLN Then
                        mMode = Motion.CCARC
                    Else
                        mMode = Motion.CWARC
                    End If
                ElseIf mCurAddress.Matches(mMotion.CCArc) Then  'Arc anti-clockwise
                    mBlockAddresses(letters.ANY) = True
                    If mPlane = Motion.XZ_PLN Then
                        mMode = Motion.CWARC
                    Else
                        mMode = Motion.CCARC
                    End If
                ElseIf mCurAddress.Matches(mMotion.Drills(0)) Then  'Drill cancel found
                    mBlockAddresses(letters.ANY) = True
                    mMode = Motion.RAPID
                    If mDrillReturnMode = Motion.I_PLN Then
                        mZpos = mInitialZBeforeDrill
                    Else
                        mZpos = mRpoint
                    End If
                ElseIf mCurAddress.Matches(mMotion.ReturnLevel(0)) Then
                    mBlockAddresses(letters.ANY) = True
                    mDrillReturnMode = Motion.I_PLN
                    If mMode > 3 Then
                        mMode = CType(Motion.HOLE_I + mDrillReturnMode, Motion)
                    End If
                ElseIf mCurAddress.Matches(mMotion.ReturnLevel(1)) Then
                    mBlockAddresses(letters.ANY) = True
                    mDrillReturnMode = Motion.R_PLN
                    If mMode > 3 Then
                        mMode = CType(Motion.HOLE_I + mDrillReturnMode, Motion)
                    End If
                ElseIf mCurAddress.Matches(mMotion.Plane(0)) Then 'Plane Change G17
                    mBlockAddresses(letters.ANY) = True
                    mPlane = Motion.XY_PLN
                ElseIf mCurAddress.Matches(mMotion.Plane(1)) Then  'Plane Change G18
                    mBlockAddresses(letters.ANY) = True
                    mPlane = Motion.XZ_PLN
                ElseIf mCurAddress.Matches(mMotion.Plane(2)) Then  'Plane Change G19
                    mPlane = Motion.YZ_PLN
                    mBlockAddresses(letters.ANY) = True
                Else
                    For r = 1 To mMotion.Drills.Length - 1 'Cycle through all 10 drilling cycles
                        If mMotion.Drills(r).Label <> Nothing Then 'NOT an empty field
                            If mCurAddress.Matches(mMotion.Drills(r)) Then
                                mMode = CType(Motion.HOLE_I + mDrillReturnMode, Motion) 'Drill cycle found
                                If mMode = Motion.HOLE_I Then
                                    mDrillClear = mInitialZBeforeDrill
                                End If
                                If mMode = Motion.HOLE_R Then
                                    mDrillClear = mRpoint
                                End If
                                mBlockAddresses(letters.ANY) = True
                                Exit For
                            End If
                        End If
                    Next r
                End If
        End Select
    End Sub

    Friend Function MatchIsComment(ByRef m As Match) As Boolean
        Return m.Value.StartsWith(mCurMachine.Comments(0)) _
        And m.Value.EndsWith(mCurMachine.Comments(2))
    End Function

    Public Sub Init(ByVal machineSetup As clsMachine)
        AppPath = My.Computer.FileSystem.CurrentDirectory
        mCurMachine = machineSetup

        If machineSetup Is Nothing Then Return
        Dim skipChars As String = ""
        For Each c As Char In mCurMachine.BlockSkip.ToCharArray
            skipChars += Regex.Escape(c)
        Next

        Dim comments(1) As String
        comments(0) = Regex.Escape(mCurMachine.Comments(0))
        comments(1) = Regex.Escape(mCurMachine.Comments(2))

        Dim progId As String = Regex.Escape(mCurMachine.ProgramId)
        '\([^\(\)]*\)|[/\*].*\n|\n|[A-Z][-+]?[0-9]*\.?[0-9]*
        Dim comment As String = comments(0) & "[^" & comments(0) & comments(1) & "]*" & comments(1) & "|"
        mRegWords = New Regex(comment & "[" & skipChars & "].*\n|\n|" & My.Resources.datRegexNcWords, RegexOptions.Compiled Or RegexOptions.IgnoreCase)
        '[:\$O]+([0-9]+)  This will return the label and value of each program.
        mRegSubs = New Regex(comment & "[" & progId & "]([0-9]+)", RegexOptions.Compiled)
    End Sub

    Public Function FilterJunk(ByRef sText As String) As String
        Dim match As String = My.Resources.datRegJunkFilter
        Return Regex.Replace(sText, match, "", RegexOptions.Compiled)
    End Function

    Private Function Color16(ByVal i As Integer) As Color
        Return Color.FromArgb(mColors16(i))
    End Function
End Class