Option Strict On
Option Explicit On
Option Compare Text
Imports System.Collections.Generic
''' <summary>
''' Reads and writes settings to disk.
''' </summary>
''' <remarks>
''' Copyright  MacGen Programming 2006
''' Jason Titcomb
''' www.CncEdit.com
''' </remarks>
Public Class clsSettings
    Private mMachines As New List(Of clsMachine)
    Public Machine As clsMachine
    Private Const DATEXTENSION As String = ".xml"
    Private mDatFolder As String
    Public Event MachineLoaded(ByVal m As clsMachine)
    Public Event MachineAdded(ByVal m As clsMachine)
    Public Event MachineDeleted(ByVal name As String)
    Public Event MachineMatched(ByVal m As clsMachine)
    Public Event MachineActivated(ByVal m As clsMachine)
    Public Event MachinesCleared()

#Region "Singleton"
    Private Shared mInstance As clsSettings
    'PRIVATE constructor can only be called from this class
    Private Sub New()
    End Sub
    ''' <summary>
    ''' Static method for creating the single instance of the Constructor
    ''' </summary>
    Public Shared Function Instance() As clsSettings
        ' initialize if not already done
        If mInstance Is Nothing Then
            mInstance = New clsSettings
        End If
        ' return the initialized instance of the Singleton Class
        Return mInstance
    End Function 'Instance
#End Region
    ''' <summary>
    ''' Sets or gets the folder containing the data files
    ''' </summary>
    Public Property DatFolder() As String
        Get
            Return mDatFolder
        End Get
        Set(ByVal value As String)
            If value.EndsWith("\") Then
                mDatFolder = value
            Else
                mDatFolder = value & "\"
            End If
        End Set
    End Property

    ''' <summary>
    ''' Sets or gets the name of the current machine
    ''' </summary>
    Public Property MachineName() As String
        Get
            Return Machine.Name
        End Get
        Set(ByVal value As String)
            For Each m As clsMachine In Me.mMachines
                If String.Compare(value, m.Name, True) = 0 Then
                    Machine = m
                    RaiseEvent MachineActivated(m)
                    Return
                End If
            Next
        End Set
    End Property

    Public Function GetDatFileNames(ByRef fo As String, Optional ByVal searchPattern As String = "*" & DATEXTENSION) As List(Of String)
        Dim fls As String()
        Dim nam As String
        Dim r As Integer, ct As Integer
        fls = IO.Directory.GetFiles(fo, searchPattern)
        ct = fls.Length
        Dim ret As New List(Of String)
        For r = 0 To ct - 1
            Try
                nam = fls(r).Substring(0, fls(r).LastIndexOf("."))
                nam = nam.Substring(nam.LastIndexOf("\") + 1)
                ret.Add(nam)
            Catch
            End Try
        Next
        Return ret
    End Function

    Public Sub LoadMachine(ByVal sName As String)
        Dim settings As New XmlReaderSettings()
        Dim r As Integer
        Machine = New clsMachine
        With settings
            .IgnoreWhitespace = True
            .IgnoreComments = True
            .IgnoreProcessingInstructions = True
            .ProhibitDtd = True
            .CloseInput = True
        End With
        Using xReader As XmlReader = XmlReader.Create(sName, settings)
            With xReader
                .MoveToContent()
                .ReadToDescendant("Name")
                Machine.Name = .ReadElementContentAsString
                Machine.Description = .ReadElementContentAsString
                Machine.AbsArcCenter = CBool(.ReadElementContentAsString)
                Machine.LatheMinus = CBool(.ReadElementContentAsString)
                Machine.HelixPitch = CBool(.ReadElementContentAsString)
                Machine.BlockSkip = .ReadElementContentAsString
                Machine.Comments = .ReadElementContentAsString
                Machine.Endmain = .ReadElementContentAsString
                Machine.MachineType = CType([Enum].Parse(GetType(MachineType), .ReadElementContentAsString), MachineType)
                Machine.RotaryAxis = CType([Enum].Parse(GetType(Axis), .ReadElementContentAsString), Axis)
                Machine.RotaryDir = CType([Enum].Parse(GetType(RotaryDirection), .ReadElementContentAsString), RotaryDirection)
                Machine.Precision = CInt(.ReadElementContentAsString)
                Machine.ProgramId = .ReadElementContentAsString
                Machine.SubReturn = .ReadElementContentAsString
                Machine.RotPrecision = CInt(.ReadElementContentAsString)
                Machine.RotaryType = CType([Enum].Parse(GetType(RotaryMotionType), .ReadElementContentAsString), RotaryMotionType)
                Machine.Searchstring = .ReadElementContentAsString
                For r = 0 To Machine.ViewAngles.Length - 1
                    Machine.ViewAngles(r) = CSng(.ReadElementContentAsString)
                Next
                For r = 0 To Machine.ViewShift.Length - 1
                    Machine.ViewShift(r) = CSng(.ReadElementContentAsString)
                Next
                Machine.Absolute = .ReadElementContentAsString
                Machine.Incremental = .ReadElementContentAsString
                Machine.CCArc = .ReadElementContentAsString
                Machine.CWArc = .ReadElementContentAsString
                Machine.DrillRapid = .ReadElementContentAsString
                For r = 0 To Machine.Drills.Length - 1
                    Machine.Drills(r) = .ReadElementContentAsString
                Next
                Machine.Linear = .ReadElementContentAsString
                Machine.Rapid = .ReadElementContentAsString
                Machine.ReturnLevel(0) = .ReadElementContentAsString
                Machine.ReturnLevel(1) = .ReadElementContentAsString
                Machine.Rotary = .ReadElementContentAsString
                Machine.XYplane = .ReadElementContentAsString
                Machine.XZplane = .ReadElementContentAsString
                Machine.YZplane = .ReadElementContentAsString
                Machine.Subcall = .ReadElementContentAsString
                Machine.SubRepeats = .ReadElementContentAsString
            End With
        End Using
        mMachines.Add(Machine)
        RaiseEvent MachineLoaded(Machine)
    End Sub

    Public Sub SaveMachine(ByVal MySetup As clsMachine)
        Dim sName As String = DatFolder & MySetup.Name & DATEXTENSION
        Dim xSettings As New XmlWriterSettings
        Dim r As Integer
        xSettings.Indent = True
        xSettings.CheckCharacters = False
        xSettings.CloseOutput = True
        Using xWriter As XmlWriter = XmlWriter.Create(sName, xSettings)
            With xWriter
                .WriteStartDocument(True)
                .WriteStartElement("Machine")
                .WriteElementString("Name", MySetup.Name)
                .WriteElementString("Description", MySetup.Description)
                .WriteElementString("AbsArcCenter", MySetup.AbsArcCenter.ToString)
                .WriteElementString("LatheMinus", MySetup.LatheMinus.ToString)
                .WriteElementString("HelixPitch", MySetup.HelixPitch.ToString)
                .WriteElementString("BlockSkip", MySetup.BlockSkip)
                .WriteElementString("Comments", MySetup.Comments)
                .WriteElementString("Endmain", MySetup.Endmain.ToString)
                .WriteElementString("MachineType", MySetup.MachineType.ToString)
                .WriteElementString("RotaryAxis", MySetup.RotaryAxis.ToString)
                .WriteElementString("RotaryDir", MySetup.RotaryDir.ToString)
                .WriteElementString("Precision", MySetup.Precision.ToString)
                .WriteElementString("ProgramId", MySetup.ProgramId)
                .WriteElementString("SubReturn", MySetup.SubReturn)
                .WriteElementString("RotPrecision", MySetup.RotPrecision.ToString)
                .WriteElementString("RotaryType", MySetup.RotaryType.ToString)
                .WriteElementString("Searchstring", MySetup.Searchstring)
                For r = 0 To 2
                    .WriteElementString("ViewAngles_" & r.ToString, MySetup.ViewAngles(r).ToString)
                Next
                For r = 0 To 2
                    .WriteElementString("ViewShift_" & r.ToString, MySetup.ViewShift(r).ToString)
                Next
                .WriteElementString("Absolute", MySetup.Absolute)
                .WriteElementString("Incremental", MySetup.Incremental)
                .WriteElementString("CCArc", MySetup.CCArc)
                .WriteElementString("CWArc", MySetup.CWArc)
                .WriteElementString("DrillRapid", MySetup.DrillRapid)
                For r = 0 To MySetup.Drills.Length - 1
                    .WriteElementString("Drills_" & r.ToString, MySetup.Drills(r))
                Next
                .WriteElementString("Linear", MySetup.Linear)
                .WriteElementString("Rapid", MySetup.Rapid)
                .WriteElementString("ReturnLevel_0", MySetup.ReturnLevel(0))
                .WriteElementString("ReturnLevel_1", MySetup.ReturnLevel(1))
                .WriteElementString("Rotary", MySetup.Rotary)
                .WriteElementString("XYplane", MySetup.XYplane)
                .WriteElementString("XZplane", MySetup.XZplane)
                .WriteElementString("YZplane", MySetup.YZplane)
                .WriteElementString("Subcall", MySetup.Subcall)
                .WriteElementString("SubRepeats", MySetup.SubRepeats)
                .WriteEndElement() 'Machine
            End With
        End Using
    End Sub

    Public Sub DeleteMachine(ByVal name As String)
        Dim fileToDelete As String = DatFolder & name & DATEXTENSION
        If IO.File.Exists(fileToDelete) Then
            IO.File.Delete(fileToDelete)
            mMachines.Remove(Machine)
            RaiseEvent MachineDeleted(name)
        End If
    End Sub

    Public Sub AddMachine(ByVal m As clsMachine)
        mMachines.Add(m)
        Machine = m
        RaiseEvent MachineAdded(m)
    End Sub

    Public Sub RenameMachine(ByVal newName As String, ByVal copy As Boolean)
        Dim newFile As String = DatFolder & newName & DATEXTENSION
        Dim thisFile As String = DatFolder & Machine.Name & DATEXTENSION

        If copy Then
            Machine.Name = newName
            SaveMachine(Machine)
        Else
            IO.File.Delete(thisFile)
            Machine.Name = newName
            SaveMachine(Machine)
        End If
    End Sub

    Public Sub LoadAllMachines()
        mMachines.Clear()
        RaiseEvent MachinesCleared()
        Dim fls As String() = IO.Directory.GetFiles(DatFolder, "*" & DATEXTENSION)
        For Each f As String In fls
            LoadMachine(f)
        Next
    End Sub

    Public Sub LoadAllMachines(ByVal sDatFolder As String)
        DatFolder = sDatFolder
        LoadAllMachines()
    End Sub

    'Loads the combo with names
    Public Sub LoadComboWithMachines(ByRef cbo As ComboBox)
        cbo.BeginUpdate()
        cbo.Items.Clear()
        For Each m As clsMachine In Me.mMachines
            cbo.Items.Add(m.Name)
        Next
        cbo.EndUpdate()
    End Sub

    Public Sub MatchMachineToFile(ByVal sFullfile As String)
        Dim ln As Integer = 0
        Dim sb As New System.Text.StringBuilder
        Dim sTemp As String
        Dim fileReader As System.IO.StreamReader
        If mMachines.Count = 0 Then
            Machine = Nothing
            Return
        End If
        'Open CNC file and get 50 lines of text
        fileReader = My.Computer.FileSystem.OpenTextFileReader(sFullfile)
        Do While fileReader.Peek >= 0
            If ln >= 50 Then Exit Do
            sb.Append(fileReader.ReadLine)
            ln += 1
        Loop
        fileReader.Close()
        sTemp = sb.ToString
        For Each m As clsMachine In mMachines
            If sTemp.Contains(m.Searchstring) Then
                Machine = m
                RaiseEvent MachineMatched(Machine)
                Return
            End If
        Next
    End Sub
End Class
