Option Strict On
Option Explicit On
Friend Class frmViewer
    Inherits System.Windows.Forms.Form
    Private mShowRapid As Boolean
    Private mShowPoints As Boolean
    Private mCncFile As String
    Private WithEvents mProcessor As clsProcessor = clsProcessor.Instance
    Private WithEvents mSetup As clsSettings = clsSettings.Instance
    Private WithEvents mViewer As MG_BasicViewer

    Private Sub frmViewer_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        mViewer = Me.MG_Viewer1
        Dim ret As Integer = Me.tscboMachines.FindString(My.Settings.LastMachine)
        If ret >= 0 Then
            Me.tscboMachines.SelectedIndex = ret
        End If

        If My.Settings.Virgin = True Then
            Me.StartPosition = FormStartPosition.CenterScreen
        Else
            Me.Location = My.Settings.ViewFormLocation
            Me.Size = My.Settings.ViewFormSize
        End If
        OpenFile(AppPath & "\Samples\Mill.cnc")
        SetDefaultViews()
        My.Settings.Virgin = False
    End Sub

    Private Sub frmViewer_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        Try
            If Me.WindowState = FormWindowState.Normal Then
                My.Settings.ViewFormLocation = Me.Location
                My.Settings.ViewFormSize = Me.Size
            End If
            My.Settings.LastMachine = Me.tscboMachines.SelectedItem.ToString
        Catch
        End Try
    End Sub

    Private Sub mnuOpenFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsbOpen.Click
        With Me.OpenFileDialog1
            .ShowDialog()
            Me.Refresh()
            If .FileName.Length > 0 Then
                OpenFile(.FileName)
            End If
        End With
    End Sub

    Private Sub OpenFile(ByVal fileName As String)
        Dim ticks(1) As Long
        mCncFile = fileName
        mSetup.MatchMachineToFile(mCncFile)

        ProcessFile(mCncFile)
        mViewer.BreakPoint = MG_BasicViewer.MotionBlocks.Count - 1

        mViewer.Pitch = mSetup.Machine.ViewAngles(0)
        mViewer.Roll = mSetup.Machine.ViewAngles(1)
        mViewer.Yaw = mSetup.Machine.ViewAngles(2)
        mViewer.Init()

        ticks(0) = Now.Ticks
        MG_Viewer1.FindExtents()
        ticks(1) = Now.Ticks
        MG_Viewer1.DynamicViewManipulation = (ticks(1) - ticks(0)) < 2000000
        MG_Viewer2.FindExtents()
        MG_Viewer3.FindExtents()
        MG_Viewer4.FindExtents()
        mViewer.Redraw(True)
    End Sub


    Private Sub ProcessFile(ByVal fileName As String)
        If fileName Is Nothing Then
            Return
        End If
        If Not IO.File.Exists(fileName) Then
            lblStatus.Text = "File does not exist!"
            Return
        End If
        lblStatus.Text = "Processing..."
        MG_BasicViewer.MotionBlocks.Clear()
        mProcessor.Init(mSetup.Machine)
        mProcessor.ProcessFile(fileName, MG_BasicViewer.MotionBlocks)

        BreakPointSlider.Maximum = MG_BasicViewer.MotionBlocks.Count - 1
        If mViewer.BreakPoint > MG_BasicViewer.MotionBlocks.Count - 1 Then
            mViewer.BreakPoint = MG_BasicViewer.MotionBlocks.Count - 1
        End If
        mViewer.GatherTools()
        lblStatus.Text = "Done"
        Progress.Value = 0

    End Sub


    Private Sub mnuViewOrient_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuTop.Click, mnuRight.Click, mnuIsometric.Click, mnuFront.Click
        Select Case CType(sender, System.Windows.Forms.ToolStripMenuItem).Tag.ToString
            Case "Top"
                mViewer.Pitch = 0
                mViewer.Roll = 0
                mViewer.Yaw = 0
            Case "Front"
                mViewer.Pitch = 270
                mViewer.Roll = 0
                mViewer.Yaw = 360
            Case "Right"
                mViewer.Pitch = 270
                mViewer.Roll = 0
                mViewer.Yaw = 270
            Case "ISO"
                mViewer.Pitch = 315
                mViewer.Roll = 0
                mViewer.Yaw = 315
        End Select
        mViewer.FindExtents()
        mViewer.Redraw(True)
    End Sub

    Private Sub MG_Viewer_MouseLocation(ByVal x As System.Single, ByVal y As System.Single) Handles mViewer.MouseLocation
        Coordinates.Text = "X=" & x.ToString("0.000") & "   Y=" & y.ToString("0.000")
    End Sub

    Private Sub DisplayCheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuRapidPoints.CheckedChanged, mnuRapidLines.CheckedChanged, mnuAxisLines.CheckedChanged, mnuAxisindicator.CheckedChanged
        If mViewer Is Nothing Then Return
        mViewer.DrawRapidLines = mnuRapidLines.Checked
        mViewer.DrawRapidPoints = mnuRapidPoints.Checked
        mViewer.DrawAxisLines = mnuAxisLines.Checked
        mViewer.DrawAxisIndicator = mnuAxisindicator.Checked
        mViewer.Redraw(True)
    End Sub

    Private Sub mProcessor_OnAddBlock(ByVal idx As Integer, ByVal ct As Integer) Handles mProcessor.OnAddBlock
        Try
            Me.Progress.Maximum = ct
            Me.Progress.Value = idx
            If ct > 10000 Then
                'Refresh every 1000 blocks
                If 1000 Mod idx = 0 Then
                    mViewer.FindExtents()
                    mViewer.Redraw(True)
                End If
            End If
        Catch ex As Exception

        End Try
    End Sub

    Private Sub ViewButtonClicked(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsbZoom.Click, tsbRotate.Click, tsbPan.Click, tsbFit.Click, tsbFence.Click, tsbSelect.Click, mnuZoom.Click, mnuSelect.Click, mnuRotate.Click, mnuPan.Click, mnuFit.Click, mnuFence.Click
        Dim tag As String = sender.GetType.GetProperty("Tag").GetValue(sender, Nothing).ToString

        Select Case tag
            Case "Fit"
                If My.Computer.Keyboard.ShiftKeyDown Then
                    MG_Viewer1.FindExtents()
                    MG_Viewer2.FindExtents()
                    MG_Viewer3.FindExtents()
                    MG_Viewer4.FindExtents()
                Else
                    mViewer.FindExtents()
                End If
            Case "Pan"
                mViewer.ViewManipMode = MG_BasicViewer.ManipMode.PAN
                tsbPan.Checked = True
                tsbRotate.Checked = False
                tsbZoom.Checked = False
                tsbFence.Checked = False
                tsbSelect.Checked = False
            Case "Fence"
                mViewer.ViewManipMode = MG_BasicViewer.ManipMode.FENCE
                tsbFence.Checked = True
                tsbRotate.Checked = False
                tsbZoom.Checked = False
                tsbPan.Checked = False
                tsbSelect.Checked = False
            Case "Zoom"
                mViewer.ViewManipMode = MG_BasicViewer.ManipMode.ZOOM
                tsbZoom.Checked = True
                tsbRotate.Checked = False
                tsbFence.Checked = False
                tsbPan.Checked = False
                tsbSelect.Checked = False
            Case "Rotate"
                mViewer.ViewManipMode = MG_BasicViewer.ManipMode.ROTATE
                tsbRotate.Checked = True
                tsbZoom.Checked = False
                tsbFence.Checked = False
                tsbPan.Checked = False
                tsbSelect.Checked = False
            Case "Select"
                mViewer.ViewManipMode = MG_BasicViewer.ManipMode.SELECTION
                tsbRotate.Checked = False
                tsbZoom.Checked = False
                tsbFence.Checked = False
                tsbPan.Checked = False
                tsbSelect.Checked = True
        End Select
    End Sub

    Private Sub ScreensClicked(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuTwoScreens.Click, mnuOneScreen.Click, mnuFourScreens.Click
        Select Case CType(sender, ToolStripMenuItem).Tag.ToString
            Case "1"
                Me.tblScreens.RowStyles(1).Height = 0
                Me.tblScreens.ColumnStyles(1).Width = 0
                MG_Viewer2.Visible = False
                MG_Viewer3.Visible = False
                MG_Viewer4.Visible = False
            Case "2"
                Me.tblScreens.RowStyles(1).Height = 0
                Me.tblScreens.ColumnStyles(1).Width = 50
                MG_Viewer2.Visible = True
                MG_Viewer3.Visible = False
                MG_Viewer4.Visible = False
            Case "4"
                Me.tblScreens.RowStyles(1).Height = 50
                Me.tblScreens.ColumnStyles(1).Width = 50
                MG_Viewer2.Visible = True
                MG_Viewer3.Visible = True
                MG_Viewer4.Visible = True
        End Select
        SetDefaultViews()
    End Sub

    Private Sub ViewportActivated(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MG_Viewer4.Enter, MG_Viewer3.Enter, MG_Viewer2.Enter, MG_Viewer1.Enter
        mViewer = CType(sender, MG_BasicViewer)
        Debug.Print(mViewer.Name)
    End Sub

    Private Sub SetDefaultViews()
        'Case "Top"
        MG_Viewer1.Pitch = 0.0F
        MG_Viewer1.Roll = 0.0F
        MG_Viewer1.Yaw = 0.0F
        MG_Viewer1.FindExtents()
        'Case "Front"
        MG_Viewer3.Pitch = 270.0F
        MG_Viewer3.Roll = 0.0F
        MG_Viewer3.Yaw = 360.0F
        MG_Viewer3.FindExtents()

        'Case "Right"
        MG_Viewer4.Pitch = 270.0F
        MG_Viewer4.Roll = 0.0F
        MG_Viewer4.Yaw = 270.0F
        MG_Viewer4.FindExtents()

        'Case "ISO"
        MG_Viewer2.Pitch = 315.0F
        MG_Viewer2.Roll = 0.0F
        MG_Viewer2.Yaw = 315.0F
        MG_Viewer2.FindExtents()
        mViewer.Redraw(True)
    End Sub

    Private Sub mViewer_OnSelection(ByVal hits As System.Collections.Generic.List(Of clsMotionRecord)) Handles mViewer.OnSelection
        lblStatus.Text = hits(0).Codestring
        Dim tipString(hits.Count - 1) As String
        For r As Integer = 0 To hits.Count - 1
            tipString(r) = hits(r).Codestring
        Next
        Me.CodeTip.SetToolTip(mViewer, String.Join(Environment.NewLine, tipString))
    End Sub

    Private Sub MG_Viewer_OnStatus(ByVal msg As String, ByVal index As Integer, ByVal max As Integer) Handles mViewer.OnStatus
        lblStatus.Text = msg
        Progress.Maximum = max
        Progress.Value = index
        StatusStrip1.Refresh()
    End Sub

    Private Sub tsbTools_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsbToolsFilter.Click
        Dim nd As TreeNode
        Using frm As New frmToolLayers
            frm.tvTools.Nodes.Clear()
            For Each tl As clsToolLayer In MG_BasicViewer.ToolLayers.Values
                nd = frm.tvTools.Nodes.Add("Tool " & tl.Number.ToString)
                nd.ForeColor = tl.Color
                nd.Checked = Not tl.Hidden
                nd.Tag = tl
            Next
            frm.tvTools.BackColor = Me.MG_Viewer1.BackColor
            frm.StartPosition = FormStartPosition.Manual
            frm.Location = Control.MousePosition
            frm.ShowDialog()
        End Using
        mViewer.Redraw(True)
    End Sub

    Private Sub mSetup_MachineActivated(ByVal m As clsMachine) Handles mSetup.MachineActivated
        With MG_Viewer1
            .RotaryDirection = CType(m.RotaryDir, RotaryDirection)
            .RotaryPlane = CType(m.RotaryAxis, Axis)
            .RotaryType = CType(m.RotaryType, RotaryMotionType)
            .ViewManipMode = MG_BasicViewer.ManipMode.SELECTION
        End With
    End Sub

    Private Sub mSetup_MachineAdded(ByVal m As clsMachine) Handles mSetup.MachineAdded
        tscboMachines.Items.Add(m.Name)
    End Sub

    Private Sub mSetup_MachineDeleted(ByVal name As String) Handles mSetup.MachineDeleted
        tscboMachines.Items.RemoveAt(tscboMachines.FindStringExact(name))
    End Sub

    Private Sub mSetup_MachineLoaded(ByVal m As clsMachine) Handles mSetup.MachineLoaded
        tscboMachines.Items.Add(m.Name)
    End Sub

    Private Sub mSetup_MachineMatched(ByVal m As clsMachine) Handles mSetup.MachineMatched
        tscboMachines.SelectedIndex = tscboMachines.FindStringExact(m.Name)
    End Sub

    Private Sub tscboMachines_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tscboMachines.SelectedIndexChanged
        Me.mSetup.MachineName = tscboMachines.SelectedItem.ToString
    End Sub

    Private Sub mSetup_MachinesCleared() Handles mSetup.MachinesCleared
        tscboMachines.Items.Clear()
    End Sub

    Private Sub frmViewer_SizeChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.SizeChanged
        If mViewer IsNot Nothing Then mViewer.Redraw(True)
    End Sub

    Private Sub BreakPoint_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BreakPointSlider.ValueChanged
        mViewer.BreakPoint = BreakPointSlider.Value
        mViewer.Redraw(True)
    End Sub

    Private Sub tsbWebCheck_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tsbWebCheck.Click
        System.Diagnostics.Process.Start(My.Resources.datBasicViewerUrl & My.Application.Info.Version.ToString)
    End Sub
End Class