# udrdtool.rb
# A simple toolbar with buttons to undo and redo actions for Sketchup 7.
#
# The icons used are from
# Author: VisualPharm (Ivan Boyko)
# Homepage: http://www.visualpharm.com
#
# The plugin has been tested in Sketchup 7 on Win XP.
# Use the plugin as required at your own risk.
# Place the file udrdtool.rb in the plugins folder.
# 
# EJT 11 Aug 2009

unless file_loaded?("udrdtool.rb")

  new_toolbar = UI::Toolbar.new("Undo Redo Tool")
  
  # Undo tool editUndo:
  cmd = UI::Command.new("Undo Tool")  { Sketchup.send_action("editUndo:") }
  cmd.small_icon = File.join(File.dirname(__FILE__), "udrdtool", "undotool_icon_sm.png")
  cmd.large_icon = File.join(File.dirname(__FILE__), "udrdtool", "undotool_icon_lg.png")
  cmd.tooltip = "Undo"
  new_toolbar.add_item(cmd)
  
   # redo tool editRedo:
  cmd = UI::Command.new("Redo Tool")  { Sketchup.send_action("editRedo:")  }
  cmd.small_icon = File.join(File.dirname(__FILE__), "udrdtool", "redotool_icon_sm.png")
  cmd.large_icon = File.join(File.dirname(__FILE__), "udrdtool", "redotool_icon_lg.png")
  cmd.tooltip = "Redo"
  new_toolbar.add_item(cmd)
  
  new_toolbar.show

  
  file_loaded "unrdtool.rb"
end
