

def set_parameters_web_dialog(model=Sketchup.active_model)
	view = model.active_view
	width = 400
	height = 550
	x = (view.vpwidth - width)/2
	y = (view.vpheight - height)/2
	x = 0 if x < 0
	y = 0 if y < 0
	params_dialog = UI::WebDialog.new($phlatboyzStrings.GetString("Parameters"), false, "Parameters", width, height, x, y, false)
	params_dialog.set_position(x, y)
	params_dialog.set_size(width, height)
	params_dialog.add_action_callback("phlatboyz_action_callback") do | web_dialog, action_name |
		model = Sketchup.active_model
		if(action_name == 'load_params')
			web_dialog.execute_script("setFormCaption('spindlespeed_id','"+$phlatboyzStrings.GetString("Spindle Speed")+"')")
			web_dialog.execute_script("setFormValue('spindlespeed','"+model.get_attribute($dict_name, $dict_spindle_speed, $default_spindle_speed).to_s+"')")
			
			web_dialog.execute_script("setFormCaption('feedrate_id','"+$phlatboyzStrings.GetString("Feed Rate")+"')")
			web_dialog.execute_script("setFormValue('feedrate','"+model.get_attribute($dict_name, $dict_feed_rate, $default_feed_rate).to_s+"')")

			web_dialog.execute_script("setFormCaption('plungerate_id','"+$phlatboyzStrings.GetString("Plunge Rate")+"')")
			web_dialog.execute_script("setFormValue('plungerate','"+model.get_attribute($dict_name, $dict_plunge_rate, $default_plunge_rate).to_s+"')")

			web_dialog.execute_script("setFormCaption('materialthickness_id','"+$phlatboyzStrings.GetString("Material Thickness")+"')")
			web_dialog.execute_script("setFormValue('materialthickness','"+Sketchup.format_length(model.get_attribute($dict_name, $dict_material_thickness, $default_material_thickness))+"')")

			web_dialog.execute_script("setFormCaption('bitdiameter_id','"+$phlatboyzStrings.GetString("Bit Diameter")+"')")
			web_dialog.execute_script("setFormValue('bitdiameter','"+Sketchup.format_length(model.get_attribute($dict_name, $dict_bit_diameter, $default_bit_diameter))+"')")

			web_dialog.execute_script("setFormCaption('tabwidth_id','"+$phlatboyzStrings.GetString("Tab Width")+"')")
			web_dialog.execute_script("setFormValue('tabwidth','"+Sketchup.format_length(model.get_attribute($dict_name, $dict_tab_width, $default_tab_width))+"')")

			web_dialog.execute_script("setFormCaption('tabdepthfactor_id','"+$phlatboyzStrings.GetString("Tab Depth Factor")+"')")
			web_dialog.execute_script("setFormValue('tabdepthfactor','"+model.get_attribute($dict_name, $dict_tab_depth_factor, $default_tab_depth_factor).to_s+"')")
			
			web_dialog.execute_script("setFormCaption('vtab_id','"+$phlatboyzStrings.GetString("V-Tabs")+"')")
			web_dialog.execute_script("setCheckbox('vtab',"+model.get_attribute($dict_name, $dict_vtabs, $default_vtabs).to_s+")")
			
			web_dialog.execute_script("setFormCaption('safex0_id','"+$phlatboyzStrings.GetString("Safe X0")+"')")
			web_dialog.execute_script("setFormValue('safex0','"+model.get_attribute($dict_name, $dict_safe_origin_x, $default_safe_origin_x).inspect()+"')")

			web_dialog.execute_script("setFormCaption('safey0_id','"+$phlatboyzStrings.GetString("Safe Y0")+"')")
			web_dialog.execute_script("setFormValue('safey0','"+model.get_attribute($dict_name, $dict_safe_origin_y, $default_safe_origin_y).inspect()+"')")

			web_dialog.execute_script("setFormCaption('safewidth_id','"+$phlatboyzStrings.GetString("Safe Length")+"')")
			# Note: problem when passing a string in the form 3' 6"  into the js method - so convert the safe width & height as unformatted length
			web_dialog.execute_script("setFormValue('safewidth','"+model.get_attribute($dict_name, $dict_safe_width, $default_safe_width).inspect()+"')")

			web_dialog.execute_script("setFormCaption('safeheight_id','"+$phlatboyzStrings.GetString("Safe Width")+"')")
			web_dialog.execute_script("setFormValue('safeheight','"+model.get_attribute($dict_name, $dict_safe_height, $default_safe_height).inspect()+"')")

			web_dialog.execute_script("setFormCaption('commenttext_id','"+$phlatboyzStrings.GetString("Comment Remarks")+"')")
			encoded_comment_text = model.get_attribute($dict_name, $dict_comment_text, $default_comment_remark).to_s
			web_dialog.execute_script("setEncodedFormValue('commenttext','"+encoded_comment_text+"','$/')")
			
		elsif(action_name == 'save')
			model.set_attribute($dict_name, $dict_spindle_speed, params_dialog.get_element_value("spindlespeed").to_i)
			model.set_attribute($dict_name, $dict_feed_rate, params_dialog.get_element_value("feedrate").to_i)
			model.set_attribute($dict_name, $dict_plunge_rate, params_dialog.get_element_value("plungerate").to_i)
			model.set_attribute($dict_name, $dict_material_thickness, Sketchup.parse_length(params_dialog.get_element_value("materialthickness")).to_f)
			model.set_attribute($dict_name, $dict_bit_diameter, Sketchup.parse_length(params_dialog.get_element_value("bitdiameter")).to_f)
			model.set_attribute($dict_name, $dict_tab_width, Sketchup.parse_length(params_dialog.get_element_value("tabwidth")).to_f)
			
			tab_depth_factor = params_dialog.get_element_value("tabdepthfactor").to_i
			model.set_attribute($dict_name, $dict_tab_depth_factor, tab_depth_factor)
			
			
			web_dialog.execute_script("isChecked('vtab')")
			val = (params_dialog.get_element_value("checkbox_hidden") == "true")
			model.set_attribute($dict_name, $dict_vtabs, val)
			
			
			safe_x = Sketchup.parse_length(params_dialog.get_element_value("safex0")).to_f
			safe_y = Sketchup.parse_length(params_dialog.get_element_value("safey0")).to_f
			safe_w = Sketchup.parse_length(params_dialog.get_element_value("safewidth")).to_f
			safe_h = Sketchup.parse_length(params_dialog.get_element_value("safeheight")).to_f
			model.set_attribute($dict_name, $dict_safe_origin_x, safe_x)
			model.set_attribute($dict_name, $dict_safe_origin_y, safe_y)
			model.set_attribute($dict_name, $dict_safe_width, safe_w)
			model.set_attribute($dict_name, $dict_safe_height, safe_h)
			
			comment_text = params_dialog.get_element_value("commenttext").delete("'\"")
			encoded_comment_text = ""
			comment_text.each{|line| encoded_comment_text += line.chomp()+"$/"}
			model.set_attribute($dict_name, $dict_comment_text, encoded_comment_text.chop().chop())
			
			params_dialog.close()
			
			set_tab_depth_factor(tab_depth_factor, model)
			set_safe_array(safe_x, safe_y, safe_w, safe_h, model)
			draw_safe_area(model)
			
		elsif(action_name == 'cancel')
			params_dialog.close()
		elsif(action_name =='restore_defaults')
			web_dialog.execute_script("setFormValue('spindlespeed','"+$default_spindle_speed.to_s+"')")
			web_dialog.execute_script("setFormValue('feedrate','"+$default_feed_rate.to_s+"')")
			web_dialog.execute_script("setFormValue('plungerate','"+$default_plunge_rate.to_s+"')")
			web_dialog.execute_script("setFormValue('materialthickness','"+$default_material_thickness.to_s+"')")
			web_dialog.execute_script("setFormValue('bitdiameter','"+$default_bit_diameter.to_s+"')")
			web_dialog.execute_script("setFormValue('tabwidth','"+$default_tab_width.to_s+"')")
			web_dialog.execute_script("setFormValue('tabdepthfactor','"+$default_tab_depth_factor.to_s+"')")
			web_dialog.execute_script("setCheckbox('vtab',"+$default_vtabs.to_s+")")
			web_dialog.execute_script("setFormValue('safex0','"+$default_safe_origin_x.to_s+"')")
			web_dialog.execute_script("setFormValue('safey0','"+$default_safe_origin_y.to_s+"')")
			web_dialog.execute_script("setFormValue('safewidth','"+$default_safe_width.inspect()+"')")
			web_dialog.execute_script("setFormValue('safeheight','"+$default_safe_height.inspect()+"')")
			web_dialog.execute_script("setFormValue('commenttext','"+$default_comment_remark+"')")
		end
	end
	
	params_dialog.set_on_close { 
		#UI.messagebox("set on close method")
	}
	
	set_param_web_dialog_file = Sketchup.find_support_file "setParamsWebDialog.html", "Tools/Phlatboyz/"
	if (set_param_web_dialog_file)
		params_dialog.set_file(set_param_web_dialog_file)
		params_dialog.show()
	end
end


def enter_file_dialog(model=Sketchup.active_model)
	output_directory_name = model.get_attribute $dict_name, $dict_output_directory_name, $default_directory_name
	output_filename = get_model_filename_or_default(model)
	status = false
	result = UI.savepanel($phlatboyzStrings.GetString("Save CNC File"), output_directory_name, output_filename)
	if(result != nil)
		result_array = validate_output_file(result)
		if(result_array != nil)
			model.set_attribute $dict_name, $dict_output_directory_name, result_array[0]
			model.set_attribute $dict_name, $dict_output_file_name, result_array[1]
			status = true
		end
	end
	status
end

def enter_set_fold_depth_dialog
	model = Sketchup.active_model
	
	prompts = [$phlatboyzStrings.GetString("Depth Factor")]
	values = [get_fold_depth_factor()]
	results = UI.inputbox prompts, values, $phlatboyzStrings.GetString("Fold Parameters")
	if(results)
		set_fold_depth_factor(results[0].to_i)
		display_fold_depth_factor()
	end
	return results
end
