
require 'sketchup.rb'
require 'Phlatboyz/Constants.rb'

class TabTool
	@@nCursor = 0

	def initialize
	    @ip = nil
		@v_tabs = true
		
		@ipoint1 = nil
		@ipoint2 = nil
		
		@valid_edge = false
		@current_edge_depth_factor = 0.0
		
		if(@@nCursor == 0)
			cursorPath = Sketchup.find_support_file($cursor_tab_tool, $cursor_directory)
			if cursorPath
				@@nCursor = UI.create_cursor(cursorPath, 13, 16)
			end	
		end
	end

	def onSetCursor()
		cursor = UI.set_cursor(@@nCursor)
	end

	def activate
	    @ip = Sketchup::InputPoint.new
	    Sketchup::set_status_text "TabTool Activated", SB_VCB_LABEL
	    self.reset(nil)
	end

	def reset(view)
	    if(view)
	        view.tooltip = nil
	        view.invalidate #if @drawn
	    end
	end

	def onMouseMove(flags, x, y, view)
		@ip.pick view, x, y
		pointArray = tabPointsFromInputPoint(@ip)
		if(@valid_edge)
			@ipoint1 = pointArray[0]
			@ipoint2 = pointArray[1]

			view.tooltip = @ip.tooltip
			#Sketchup::set_status_text @ip.tooltip, SB_VCB_LABEL
		end
		view.invalidate if(@ip.display?)
	end

	def onLButtonDown(flags, x, y, view)
		@ip.pick view, x, y
		pointArray = tabPointsFromInputPoint(@ip)
		if(@valid_edge)
			self.create_geometry(pointArray, view)
		end
		self.reset(view)
	    # Clear any inference lock
	    view.lock_inference
		Sketchup::set_status_text "tab complete", SB_VCB_LABEL
	end
	
	
	def onKeyDown(key, repeat, flags, view)
		if key == 86 # v key
			@v_tabs = !@v_tabs
			view.invalidate
		end
	end


	def draw(view)
		if(@valid_edge)
			self.draw_geometry(@ipoint1, @ipoint2, view)
		end
	end

	def tabPointsFromInputPoint(inputPoint)
		e = inputPoint.edge

		pointArray = nil
		@valid_edge = false
		if(e != nil)
			edgeType = e.get_attribute $dict_name, $dict_edge_type
			if(edgeType == $key_inside_cut || edgeType == $key_outside_cut)
				@valid_edge = true
				current_tab_width = Sketchup.active_model.get_attribute $dict_name, $dict_tab_width, $default_tab_width

				@current_edge_depth_factor = e.get_attribute($dict_name, $dict_cut_depth_factor)
				
				ep1 = e.start.position
				ep2 = e.end.position

				if e.length < current_tab_width
					# The edge width is smaller than the tab width - just use the entire edge
					point1 = ep1
					point2 = ep2
				else
					# When the tab is smaller than the edge then use the input point as center
					v = ep1.vector_to ep2 
					pt = inputPoint.position
					half = current_tab_width/2
					point1 = pt.offset(v, -half)
					point2 = pt.offset(v, half)
					# if one of the tab end points goes past the edge end, then use the edge end point
					point1 = ep1 if pt.distance(ep1) < half
					point2 = ep2 if pt.distance(ep2) < half
				end
				pointArray = Array[point1, point2]
			end
		end
		return pointArray
	end

	# Draw the geometry
	def draw_geometry(pt1, pt2, view)
		view.drawing_color = $color_tab_drawing
		#view.line_stipple = "---.---"
		view.line_width = 6.0
	    view.draw_line(pt1, pt2)
	end
	
	def create_geometry(pointArray, view)
		model = view.model
		entities = model.entities
		if(@valid_edge)
			model.start_operation "Creating Tab"

			tab_full_depth_factor = get_tab_depth_factor()/100.0
			
			if(@v_tabs)
				vtab_segments = 12

				pt1 = pointArray[0]
				pt2 = pointArray[1]
				
				ptm = Geom.linear_combination(0.50, pt1, 0.50, pt2)
				
				pre_pt_arr = _div_point_n(pt1, ptm, vtab_segments)
				post_pt_arr = _div_point_n(ptm, pt2, vtab_segments)
				
				factor_arr = _div_factor_n(@current_edge_depth_factor, tab_full_depth_factor, vtab_segments)
				range = Range.new(0, vtab_segments - 1)
				
				# Pre Tab Array
				for i in range
					_add_tab_edge(entities, pre_pt_arr[i], pre_pt_arr[i + 1], factor_arr[i])
				end

				# Post Tab Array
				factor_arr.reverse!
				for i in range
					_add_tab_edge(entities, post_pt_arr[i], post_pt_arr[i + 1], factor_arr[i])
				end

			else
				_add_tab_edge(entities, pointArray[0], pointArray[1], tab_full_depth_factor)
			end

			model.commit_operation
		    Sketchup::set_status_text "Tab Created", SB_VCB_LABEL
		end
	end
	
	private
	
	def _div_point_n(pt1, pt2, n)
		# divide the segment between pt1 and pt2 into n equal lengths and return an array of length n+1 for the points
		pt_arr = Array.new(n + 1)
		pt_arr[0] = pt1
		pt_arr[n] = pt2
		for i in Range.new(1,n-1)
			lin_pct = (1.0*i)/n
			pt_arr[i] = Geom.linear_combination((1.0 - lin_pct), pt1, lin_pct, pt2)
		end
		return pt_arr
	end
	
	def _div_factor_n(factor1, factor2, n)
		# divide the factors into n values returning and array of n
		factor_arr = Array.new(n)
		delta = (factor2 - factor1)/n
		for i in Range.new(0,n-1)
			factor_arr[i] = factor1 + (i + 0.5)*delta
		end
		return factor_arr
	end

	def _add_tab_edge(entities, pt1, pt2, depth_factor)
		edge = entities.add_line(pt1, pt2)
		edge.set_attribute($dict_name, $dict_cut_depth_factor, depth_factor)
		edge.set_attribute($dict_name, $dict_edge_type, $key_tab_cut)
		edge.material = $color_tab_cut
	end


end
