

def enter_set_parameters_dialog
	model = Sketchup.active_model
	current_thickness = model.get_attribute $dict_name, $dict_material_thickness, $default_material_thickness
	current_bit_diameter = model.get_attribute $dict_name, $dict_bit_diameter, $default_bit_diameter
	current_tab_width = model.get_attribute $dict_name, $dict_tab_width, $default_tab_width
	current_tab_depth = get_tab_depth_factor(model)
	current_Spindle_Speed = model.get_attribute $dict_name, $dict_spindle_speed, $default_spindle_speed
	current_Feed_Rate = model.get_attribute $dict_name, $dict_feed_rate, $default_feed_rate
	current_Plunge_Feed = model.get_attribute $dict_name, $dict_plunge_rate, $default_plunge_rate
	current_comment_remark = model.get_attribute $dict_name,$dict_comment_text, $default_comment_remark
	safe_area_array = get_safe_array(model)

	prompts = [
		$phlatboyzStrings.GetString("Spindle Speed"),
		$phlatboyzStrings.GetString("Feed Rate"),
		$phlatboyzStrings.GetString("Plunge Rate"),
		$phlatboyzStrings.GetString("Material Thickness"), 
		$phlatboyzStrings.GetString("Bit Diameter"),
		$phlatboyzStrings.GetString("Tab Width"),
		$phlatboyzStrings.GetString("Tab Depth Factor"), 
		$phlatboyzStrings.GetString("Safe X0"),
		$phlatboyzStrings.GetString("Safe Y0"),
		$phlatboyzStrings.GetString("Safe Width"),
		$phlatboyzStrings.GetString("Safe Height"),
		$phlatboyzStrings.GetString("Comment Remarks"),
		]
	values = [
		current_Spindle_Speed,
		current_Feed_Rate,
		current_Plunge_Feed,
		current_thickness, 
		current_bit_diameter,
		current_tab_width, 
		current_tab_depth, 
		safe_area_array[0],
		safe_area_array[1],
		safe_area_array[2],
		safe_area_array[3],
		current_comment_remark,
		]
	results = UI.inputbox prompts, values, $phlatboyzStrings.GetString("Parameters")
	if(results)
		model.set_attribute $dict_name, $dict_spindle_speed, results[0].to_f
		model.set_attribute $dict_name, $dict_feed_rate, results[1].to_f
		model.set_attribute $dict_name, $dict_plunge_rate, results[2].to_f
		model.set_attribute $dict_name, $dict_material_thickness, results[3].to_f
		model.set_attribute $dict_name, $dict_bit_diameter, results[4].to_f
		model.set_attribute $dict_name, $dict_tab_width, results[5].to_f
		model.set_attribute $dict_name, $dict_comment_text, results[11]
		set_tab_depth_factor(results[6].to_i, model)
		
		set_safe_array(results[7].to_f, results[8].to_f, results[9].to_f, results[10].to_f, model)
    
		draw_safe_area(model)
    
	end
end

def set_parameters_web_dialog(model=Sketchup.active_model)
	view = model.active_view
	width = 400
	height = 550
	x = (view.vpwidth - width)/2
	y = (view.vpheight - height)/2
	x = 0 if x < 0
	y = 0 if y < 0
	params_dialog = UI::WebDialog.new($phlatboyzStrings.GetString("Parameters"), false, "Parameters", width, height, x, y, false)
	params_dialog.set_position(x, y)
	params_dialog.set_size(width, height)
	params_dialog.add_action_callback("phlatboyz_action_callback") do | web_dialog, action_name |
		model = Sketchup.active_model
		if(action_name == 'load_params')
			web_dialog.execute_script("setFormCaption('spindlespeed_id','"+$phlatboyzStrings.GetString("Spindle Speed")+"')")
			web_dialog.execute_script("setFormValue('spindlespeed','"+model.get_attribute($dict_name, $dict_spindle_speed, $default_spindle_speed).to_s+"')")
			
			web_dialog.execute_script("setFormCaption('feedrate_id','"+$phlatboyzStrings.GetString("Feed Rate")+"')")
			web_dialog.execute_script("setFormValue('feedrate','"+model.get_attribute($dict_name, $dict_feed_rate, $default_feed_rate).to_s+"')")

			web_dialog.execute_script("setFormCaption('plungerate_id','"+$phlatboyzStrings.GetString("Plunge Rate")+"')")
			web_dialog.execute_script("setFormValue('plungerate','"+model.get_attribute($dict_name, $dict_plunge_rate, $default_plunge_rate).to_s+"')")

			web_dialog.execute_script("setFormCaption('materialthickness_id','"+$phlatboyzStrings.GetString("Material Thickness")+"')")
			web_dialog.execute_script("setFormValue('materialthickness','"+Sketchup.format_length(model.get_attribute($dict_name, $dict_material_thickness, $default_material_thickness))+"')")

			web_dialog.execute_script("setFormCaption('bitdiameter_id','"+$phlatboyzStrings.GetString("Bit Diameter")+"')")
			web_dialog.execute_script("setFormValue('bitdiameter','"+Sketchup.format_length(model.get_attribute($dict_name, $dict_bit_diameter, $default_bit_diameter))+"')")

			web_dialog.execute_script("setFormCaption('tabwidth_id','"+$phlatboyzStrings.GetString("Tab Width")+"')")
			web_dialog.execute_script("setFormValue('tabwidth','"+Sketchup.format_length(model.get_attribute($dict_name, $dict_tab_width, $default_tab_width))+"')")

			web_dialog.execute_script("setFormCaption('tabdepthfactor_id','"+$phlatboyzStrings.GetString("Tab Depth Factor")+"')")
			web_dialog.execute_script("setFormValue('tabdepthfactor','"+model.get_attribute($dict_name, $dict_tab_depth_factor, $default_tab_depth_factor).to_s+"')")

			web_dialog.execute_script("setFormCaption('safex0_id','"+$phlatboyzStrings.GetString("Safe X0")+"')")
			web_dialog.execute_script("setFormValue('safex0','"+Sketchup.format_length(model.get_attribute($dict_name, $dict_safe_origin_x, $default_safe_origin_x))+"')")

			web_dialog.execute_script("setFormCaption('safey0_id','"+$phlatboyzStrings.GetString("Safe Y0")+"')")
			web_dialog.execute_script("setFormValue('safey0','"+Sketchup.format_length(model.get_attribute($dict_name, $dict_safe_origin_y, $default_safe_origin_y))+"')")

			web_dialog.execute_script("setFormCaption('safewidth_id','"+$phlatboyzStrings.GetString("Safe Width")+"')")
			# Note: problem when passing a string in the form 3' 6"  into the js method - so convert the safe width & height as unformatted length
			web_dialog.execute_script("setFormValue('safewidth','"+model.get_attribute($dict_name, $dict_safe_width, $default_safe_width).inspect()+"')")

			web_dialog.execute_script("setFormCaption('safeheight_id','"+$phlatboyzStrings.GetString("Safe Height")+"')")
			web_dialog.execute_script("setFormValue('safeheight','"+model.get_attribute($dict_name, $dict_safe_height, $default_safe_height).inspect()+"')")

			web_dialog.execute_script("setFormCaption('commenttext_id','"+$phlatboyzStrings.GetString("Comment Remarks")+"')")
			web_dialog.execute_script("setFormValue('commenttext','"+model.get_attribute($dict_name, $dict_comment_text, $default_comment_remark).to_s+"')")

		elsif(action_name == 'save')
			model.set_attribute($dict_name, $dict_spindle_speed, params_dialog.get_element_value("spindlespeed").to_i)
			model.set_attribute($dict_name, $dict_feed_rate, params_dialog.get_element_value("feedrate").to_i)
			model.set_attribute($dict_name, $dict_plunge_rate, params_dialog.get_element_value("plungerate").to_i)
			model.set_attribute($dict_name, $dict_material_thickness, Sketchup.parse_length(params_dialog.get_element_value("materialthickness")).to_f)
			model.set_attribute($dict_name, $dict_bit_diameter, Sketchup.parse_length(params_dialog.get_element_value("bitdiameter")).to_f)
			model.set_attribute($dict_name, $dict_tab_width, Sketchup.parse_length(params_dialog.get_element_value("tabwidth")).to_f)
			
			tab_depth_factor = params_dialog.get_element_value("tabdepthfactor").to_i
			model.set_attribute($dict_name, $dict_tab_depth_factor, tab_depth_factor)
			
			safe_x = Sketchup.parse_length(params_dialog.get_element_value("safex0")).to_f
			safe_y = Sketchup.parse_length(params_dialog.get_element_value("safey0")).to_f
			safe_w = Sketchup.parse_length(params_dialog.get_element_value("safewidth")).to_f
			safe_h = Sketchup.parse_length(params_dialog.get_element_value("safeheight")).to_f
			model.set_attribute($dict_name, $dict_safe_origin_x, safe_x)
			model.set_attribute($dict_name, $dict_safe_origin_y, safe_y)
			model.set_attribute($dict_name, $dict_safe_width, safe_w)
			model.set_attribute($dict_name, $dict_safe_height, safe_h)
			
			model.set_attribute($dict_name, $dict_comment_text, params_dialog.get_element_value("commenttext"))
			
			params_dialog.close()
			
			set_tab_depth_factor(tab_depth_factor, model)
			set_safe_array(safe_x, safe_y, safe_w, safe_h, model)
			draw_safe_area(model)
			
		elsif(action_name == 'cancel')
			params_dialog.close()
		elsif(action_name =='restore_defaults')
			web_dialog.execute_script("setFormValue('spindlespeed','"+$default_spindle_speed.to_s+"')")
			web_dialog.execute_script("setFormValue('feedrate','"+$default_feed_rate.to_s+"')")
			web_dialog.execute_script("setFormValue('plungerate','"+$default_plunge_rate.to_s+"')")
			web_dialog.execute_script("setFormValue('materialthickness','"+$default_material_thickness.to_s+"')")
			web_dialog.execute_script("setFormValue('bitdiameter','"+$default_bit_diameter.to_s+"')")
			web_dialog.execute_script("setFormValue('tabwidth','"+$default_tab_width.to_s+"')")
			web_dialog.execute_script("setFormValue('tabdepthfactor','"+$default_tab_depth_factor.to_s+"')")
			web_dialog.execute_script("setFormValue('safex0','"+$default_safe_origin_x.to_s+"')")
			web_dialog.execute_script("setFormValue('safey0','"+$default_safe_origin_y.to_s+"')")
			web_dialog.execute_script("setFormValue('safewidth','"+$default_safe_width.inspect()+"')")
			web_dialog.execute_script("setFormValue('safeheight','"+$default_safe_height.inspect()+"')")
		end
	end
	
	
	params_dialog.set_on_close { 
		#UI.messagebox("set on close method")
	}
	
	
	set_param_web_dialog_file = Sketchup.find_support_file "setParamsWebDialog.html", "Tools/Phlatboyz/"
	if (set_param_web_dialog_file)
		params_dialog.set_file(set_param_web_dialog_file)
		params_dialog.show()
	end
end


def enter_file_dialog(model=Sketchup.active_model)
	output_directory_name = model.get_attribute $dict_name, $dict_output_directory_name, $default_directory_name
	output_filename = get_model_filename_or_default(model)
	status = false
	result = UI.savepanel($phlatboyzStrings.GetString("Save CNC File"), output_directory_name, output_filename)
	if(result != nil)
		result_array = validate_output_file(result)
		if(result_array != nil)
			model.set_attribute $dict_name, $dict_output_directory_name, result_array[0]
			model.set_attribute $dict_name, $dict_output_file_name, result_array[1]
			status = true
		end
	end
	status
end

def enter_set_fold_depth_dialog
	model = Sketchup.active_model
	
	prompts = [$phlatboyzStrings.GetString("Depth Factor")]
	values = [get_fold_depth_factor()]
	results = UI.inputbox prompts, values, $phlatboyzStrings.GetString("Fold Parameters")
	if(results)
		set_fold_depth_factor(results[0].to_i)
		display_fold_depth_factor()
	end
	return results
end
