#-----------------------------------------------------------------------------
# Name        :   PhlatBoyzTools
# Description :   A set of tools for marking up Phlatland Sketchup drawings and generating Phlatprinter g-code.
# Menu Item   :   
# Context Menu:   
# Usage       :   
# Date        :   22 Feb 2009
# Type        :   
# Version     :   0.912
#-----------------------------------------------------------------------------

require 'sketchup.rb'
require 'LangHandler.rb'

class SketchupExtension
    attr_accessor :name, :description, :version, :creator, :copyright

    # REVIEW: Passing the description in as an argument to new makes it hard to use
    # very descriptive descriptions.
    def initialize(name, filePath)
        @name = name
        @description = description
        @path = filePath
        
        @version = "0.912"
        @creator = "Phlatboyz"
        @copyright = "02/22/2009, Phlatboyz"
    end

    def load
        require @path
    end
end

$phlatboyzStrings = LanguageHandler.new("PhlatBoyz.strings")

puts "parsed strings"

#Register the Phlatboyz Tools with SU's extension manager
meshToolsExtension = SketchupExtension.new $phlatboyzStrings.GetString("Phlatboyz Tools"), "Phlatboyz/PhlatboyzMenus.rb"

puts "Created extension"
 
meshToolsExtension.description=$phlatboyzStrings.GetString("PhlatboyzDescription")

puts "extension description" 

Sketchup.register_extension meshToolsExtension, false

puts "registered extension" 
$edge_count = 0


