require 'sketchup.rb'
require 'Phlatboyz/PSUpgrade.rb'

module PhlatScript

  class AppChangeObserver < Sketchup::AppObserver

    def onNewModel(model)
      PhlatScript.setModelOptions(model)
    end

    def onOpenModel(model)
      PSUpgrader.upgrade
      PhlatScript.setModelOptions(model)
    end

  end

  class ModelChangeObserver < Sketchup::ModelObserver

    def onSaveModel(model)
      # This is what is needed to keep from losing the Phlatboz color when saving the file.
      PhlatScript.doSave(model)
    end

  end

end