

require 'Phlatboyz/PhlatCut.rb'

module PhlatScript

  class PlungeCut < PhlatCut
    attr_accessor :position

    def PlungeCut.radius
      return (Sketchup.active_model.get_attribute $dict_name, $dict_bit_diameter, $default_bit_diameter) / 2.0
    end

    def PlungeCut.cut_key
      return $key_plunge_cut
    end

    def PlungeCut.load(pt)
      return self.new(pt)
    end

    def PlungeCut.cut(pt)
      plungecut = PlungeCut.new
      plungecut.cut(pt)
      return plungecut
    end

    def PlungeCut.preview(view, pt)
      view.drawing_color = $color_plunge_cut
      view.line_width = 3.0
      begin
        n_angles = 16
        delta = 360.0 / n_angles
        dr = Math::PI/180.0
        angle = 0.0
        pt_arr = Array.new
        for i in 0..n_angles
          radians = angle * dr
          pt_arr << Geom::Point3d.new(pt.x + radius*Math.sin(radians), pt.y + radius*Math.cos(radians), 0)
          angle += delta
        end
        status = view.draw_polyline(pt_arr)
      rescue
        UI.messagebox "Exception in PlungeTool.draw_geometry "+$!
      end
    end

    def initialize(pt=nil)
      super()
      @position = (pt.nil?) ? Geom::Point3d.new(0, 0, 0) : pt.vertices.first.position
    end

    def cut(pt)
      Sketchup.active_model.start_operation "Cutting Plunge", true
      @position = pt
      entities = Sketchup.active_model.entities
      end_pt = Geom::Point3d.new(self.x + PlungeCut.radius, self.y, 0)
      newedges = entities.add_edges(self.position, end_pt)
      vectz = Geom::Vector3d.new(0,0,-1)
      circleInner = entities.add_circle(self.position, vectz, PlungeCut.radius, 12)
      entities.add_face(circleInner)
      newedges[0].material = $color_plunge_cut
      newedges[0].set_attribute $dict_name, $dict_edge_type, $key_plunge_cut
      Sketchup.active_model.commit_operation
    end

    def x
      return self.position.x
    end

    def x=(x)
      @position = Geom::Point3d.new(x, self.y, 0)
    end

    def y
      return self.position.y
    end

    def y=(y)
      @position = Geom::Point3d.new(self.x, y, 0)
    end

    def erase
      ph = Sketchup.active_model.active_view.pick_helper
      sc = Sketchup.active_model.active_view.screen_coords(@position)
      dele = []

      if (ph.do_pick(sc.x, sc.y) > 0)
        ph.all_picked.each { |pick|
          pc = PhlatCut.from_edge(pick)
          next if !pc
          if ((pc.class) == self.class)
            dele.push(pick)
            pick.vertices.each { |v|
              v.loops.each { |l|
                l.edges.each { |e| dele.push(e) }
              }
            }
          end
        }
      end
      Sketchup.active_model.entities.erase_entities dele
    end
  
    def cut_points(reverse=false)
      yield (@position, self.cut_factor)
    end

    def cut_factor
      return $cut_depth_factor_outside
    end

    # marks all entities as having been milled in gcodeutil
    def processed=(val)
      getEdge.set_attribute($dict_name, $dict_object_mark, val)
    end

    def processed
      return getEdge.get_attribute($dict_name, $dict_object_mark, false)
    end

  private
    
    def getEdge
      ph = Sketchup.active_model.active_view.pick_helper
      sc = Sketchup.active_model.active_view.screen_coords(@position)
      edge = nil
      if (ph.do_pick(sc.x, sc.y) > 0)
        ph.all_picked.each { |pick|
          pc = PhlatCut.from_edge(pick)
          next if !pc
          edge = pick if ((pc.class) == self.class)
        }
      end
      return edge
    end

  end

end