
require 'sketchup.rb'
require 'Phlatboyz/Constants.rb'
require 'Phlatboyz/PhlatTool.rb'
require 'Phlatboyz/tools/TabCut.rb'

module PhlatScript

  class TabTool < PhlatTool
    @@nCursor = 0
    @@vCursor = 0

    def initialize
      super
      @ipoint1 = nil
      @ipoint2 = nil
      @@D = true
      @valid_edge = false
      @current_edge_depth_factor = 0.0
      @ph = nil
      
      if(@@nCursor == 0)
        cursorPath = Sketchup.find_support_file($cursor_tab_tool, $cursor_directory)
        if(cursorPath)
          @@nCursor = UI.create_cursor(cursorPath, 13, 16)
        end	
      end
      if(@@vCursor == 0)
        cursorPath = Sketchup.find_support_file($cursor_vtab_tool, $cursor_directory)
        if(cursorPath)
          @@vCursor = UI.create_cursor(cursorPath, 13, 16)
        end	
      end
    end

    def activate
      @ph = Sketchup.active_model.active_view.pick_helper
      super
    end

    def onSetCursor()
      @cursor = (get_vtab_flag() ? @@vCursor : @@nCursor)
      super
    end

    def onMouseMove(flags, x, y, view)
      @ip.pick(view, x, y)

      @os_cut = nil
      if (@ph.do_pick(x, y) > 0)
        cut = nil
        @ph.all_picked.each { |e|
          if (e.kind_of?(Sketchup::Edge))
            @os_cut = PhlatCut.from_edge(e)
            if @os_cut.kind_of?(PhlatScript::OffsetCut)
              @proj_pt = @ip.position.project_to_line(@os_cut.edge.line)
              view.invalidate
              break
            else
              @os_cut = nil
            end
          end
        }
      end
      Sketchup.status_text = "#{@ip.position.to_s}"
      view.invalidate
    end

    def onLButtonDown(flags, x, y, view)
      @ip.pick view, x, y
      pointArray = tabPointsFromInputPoint(@ip)
      if(@valid_edge)
#        TabCut.cut(@ipoint1, @ipoint2, get_vtab_flag(view.model))
      end

      view.lock_inference
      if (@ph.do_pick(x, y) > 0)
        cut = nil
        @ph.all_picked.each { |e|
          if (e.kind_of?(Sketchup::Edge))
            os_cut = PhlatCut.from_edge(e)
            if os_cut.kind_of?(PhlatScript::OffsetCut)
              @proj_pt = @ip.position.project_to_line(os_cut.edge.line)
              tab = TabCut.cut(os_cut, @proj_pt)
              tab.vtab = get_vtab_flag(view.model)
              break
            end
          end
        }
      end

      self.reset(view)
        # Clear any inference lock
        view.lock_inference
      Sketchup::set_status_text("tab complete", SB_VCB_LABEL)
    end
    
    def onKeyDown(key, repeat, flags, view)
      if(key == 86) # v key
        toggle_vtab_flag()
        self.reset(view)
        onSetCursor()
      elsif (key == 68) # d
        @@D = !@@D
        view.invalidate
      end
    end

    def draw(view)
      if (!@os_cut.nil?)
        TabCut.preview(view, @os_cut, @proj_pt, get_vtab_flag(view.model))
      end
      self.highlight_tabs(view) if @@D
    end

    def tabPointsFromInputPoint(inputPoint)
      e = inputPoint.edge

      pointArray = nil
      @valid_edge = false
      if(e != nil)
        edgeType = e.get_attribute $dict_name, $dict_edge_type
        if(edgeType == $key_inside_cut || edgeType == $key_outside_cut)
          @valid_edge = true
          current_tab_width = Sketchup.active_model.get_attribute($dict_name, $dict_tab_width, $default_tab_width)

          @current_edge_depth_factor = e.get_attribute($dict_name, $dict_cut_depth_factor)
          
          ep1 = e.start.position
          ep2 = e.end.position

          if(e.length < current_tab_width)
            # The edge width is smaller than the tab width - just use the entire edge
            point1 = ep1
            point2 = ep2
          else
            # When the tab is smaller than the edge then use the input point as center
            v = ep1.vector_to ep2 
            pt = inputPoint.position
            half = current_tab_width/2
            point1 = pt.offset(v, -half)
            point2 = pt.offset(v, half)
            # if one of the tab end points goes past the edge end, then use the edge end point
            point1 = ep1 if pt.distance(ep1) < half
            point2 = ep2 if pt.distance(ep2) < half
          end
          pointArray = Array[point1, point2]
        end
      end
      return pointArray
    end

    def highlight_tabs(view)
      view.line_width = 6.0
      view.model.entities.each { |e|
        if (e.kind_of?(Sketchup::Edge))
          cut = PhlatCut.from_edge(e)
          cut.highlight(view) if cut.kind_of?(PhlatScript::TabCut)
        end
      }
    end
    
    def statusText
      return "Select edge to create tab. D to toggle highlight display"
    end
   
    def cut_class
      return TabCut
    end

    private

    def get_vtab_flag(model=Sketchup.active_model)
    	return model.get_attribute($dict_name, $dict_vtabs, $default_vtabs)
    end

    def toggle_vtab_flag(model=Sketchup.active_model)
    	val = model.get_attribute($dict_name, $dict_vtabs, $default_vtabs)
    	model.set_attribute($dict_name, $dict_vtabs, !val)
    end
  end

end