
require 'sketchup.rb'
require 'Phlatboyz/Constants.rb'
require 'Phlatboyz/PhlatTool.rb'
require 'Phlatboyz/tools/TabCut.rb'

module PhlatScript

  class TabTool < PhlatTool
    @@nCursor = 0
    @@vCursor = 0

    def initialize
      super
      @@D = true
      @ph = nil
      @loop_length = 0
      @auto = false
      @auto_pts = nil
      @pcut = nil
      @pt = nil
      
      if(@@nCursor == 0)
        cursorPath = Sketchup.find_support_file($cursor_tab_tool, $cursor_directory)
        if(cursorPath)
          @@nCursor = UI.create_cursor(cursorPath, 13, 16)
        end	
      end
      if(@@vCursor == 0)
        cursorPath = Sketchup.find_support_file($cursor_vtab_tool, $cursor_directory)
        if(cursorPath)
          @@vCursor = UI.create_cursor(cursorPath, 13, 16)
        end	
      end
    end

    def onSetCursor()
      @cursor = (get_vtab_flag() ? @@vCursor : @@nCursor)
      super
    end

    def onCancel(reason, view)
      if (reason == 0) && (@auto)# escape pressed
      end
    end

    def onMouseMove(flags, x, y, view)
      res, @pcut, @pt = pick_point(x, y, view)
      if (((flags & 1) == 1)) 
        # create the tab cut
        TabCut.cut(@pcut, @pt).vtab = get_vtab_flag(view.model) if (@pcut && @pt)
        view.model.selection.clear
        view.lock_inference
        self.reset(view)
        Sketchup::set_status_text("Tab complete", SB_VCB_LABEL)
      end
      if (@auto) 
      end
      view.invalidate
    end

    def onLButtonDown(flags, x, y, view)
      added = false
      if (@auto)
        # store the point where the auto tab starts
        @loop_length = 0
        @pcut.loop.edges.each { |le| @loop_length += le.length } if (@pcut.loop)
      end
      if (((flags & 1) == 1)) 
      res, @pcut, @pt = pick_point(x, y, view) 
      end
    end

    def onLButtonUp(flags, x, y, view)
        # create the tab cut
        TabCut.cut(@pcut, @pt).vtab = get_vtab_flag(view.model) if (@pcut && @pt)
        view.model.selection.clear
        view.lock_inference
      self.reset(view)
      Sketchup::set_status_text("Tab complete", SB_VCB_LABEL)
    end

    def onKeyDown(key, repeat, flags, view)
      if(key == 86) # v key
        toggle_vtab_flag()
        self.reset(view)
        onSetCursor()
      elsif (key == 68) # d
        @@D = !@@D
        view.invalidate
      elsif (key == 17) # CTRL
        @auto = !@auto
      end
    end

    def draw(view)
      TabCut.preview(view, @pcut, @pt, get_vtab_flag(view.model)) if (@pcut && @pt)
      self.highlight_tabs(view) if @@D
    end

    def highlight_tabs(view)
      view.line_width = 6.0
      view.model.entities.each { |e|
        if (e.kind_of?(Sketchup::Edge))
          cut = PhlatCut.from_edge(e)
          cut.highlight(view) if cut.kind_of?(PhlatScript::TabCut)
        end
      }
    end

    def statusText
      return "Select edge to create tab. D to toggle highlight display"
    end

    def cut_class
      return TabCut
    end

    private

    def get_vtab_flag(model=Sketchup.active_model)
    	return model.get_attribute($dict_name, $dict_vtabs, $default_vtabs)
    end

    def toggle_vtab_flag(model=Sketchup.active_model)
    	val = model.get_attribute($dict_name, $dict_vtabs, $default_vtabs)
    	model.set_attribute($dict_name, $dict_vtabs, !val)
    end

    def pick_point(x, y, view)
      @ph = view.pick_helper if !@ph
      os_cut = nil
      proj_pt = nil
      @ip.pick view, x, y
      view.lock_inference
      if (@ph.do_pick(x, y) > 0)
        @ph.all_picked.each { |e|
          os_cut = PhlatCut.from_edge(e)
          if os_cut.kind_of?(PhlatScript::OffsetCut)
            proj_pt = @ip.position.project_to_line(os_cut.edge.line)
            break
          end
        }
      end
      os_cut = nil if !proj_pt
      return [!os_cut.nil?, os_cut, proj_pt]
    end

  end

end
